@extends('layouts.admin.app')

@section('title', translate('Edit Cashback Setting'))

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('admin.dashboard')}}">
                                {{translate('Dashboard')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('admin.cashback.index')}}">
                                {{translate('Cashback Management')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{translate('Edit Cashback Setting')}}</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">{{translate('Edit Cashback Setting')}}</h1>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">
                <i class="tio-edit"></i>
                {{translate('Edit')}}
                @if($cashbackSetting->branch_id)
                    {{$cashbackSetting->branch->name}}
                @else
                    {{translate('Global')}}
                @endif
                {{translate('Cashback Setting')}}
            </h4>
        </div>
        <div class="card-body">
            <form action="{{route('admin.cashback.update', $cashbackSetting->id)}}" method="post">
                @csrf
                <div class="row">
                    @if($cashbackSetting->branch_id)
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="input-label">{{translate('Branch')}}</label>
                            <input type="text" class="form-control" value="{{$cashbackSetting->branch->name}}" readonly>
                        </div>
                    </div>
                    @endif

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status"
                                       value="1" {{$cashbackSetting->status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <input type="number" class="form-control" name="cashback_percentage"
                                   value="{{$cashbackSetting->cashback_percentage}}"
                                   step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <input type="number" class="form-control" name="minimum_order_amount"
                                   value="{{$cashbackSetting->minimum_order_amount}}"
                                   step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <input type="number" class="form-control" name="maximum_cashback_amount"
                                   value="{{$cashbackSetting->maximum_cashback_amount}}"
                                   step="0.01" min="0">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" {{$cashbackSetting->wallet_discount_status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                   value="{{$cashbackSetting->wallet_discount_max_percentage}}"
                                   step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                </div>

                <div class="btn-toolbar justify-content-between">
                    <div class="btn-group">
                        <a href="{{route('admin.cashback.index')}}" class="btn btn-secondary">
                            <i class="tio-chevron-left"></i> {{translate('Back')}}
                        </a>
                    </div>
                    <div class="btn-group">
                        <button type="submit" class="btn btn-primary">
                            <i class="tio-save"></i> {{translate('Update Setting')}}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
