@extends('layouts.branch.app')

@section('title', translate('Edit Cashback Settings'))

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('branch.dashboard')}}">
                                {{translate('Dashboard')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('branch.cashback.index')}}">
                                {{translate('Cashback Settings')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{translate('Edit Settings')}}</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">{{translate('Edit Cashback Settings')}}</h1>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Edit Form -->
    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">
                <i class="tio-edit"></i>
                {{translate('Edit Cashback Settings')}} - {{$branch->name}}
            </h4>
        </div>
        <div class="card-body">
            @if($cashbackSetting)
            <form action="{{route('branch.cashback.update')}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system for your branch')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status"
                                       value="1" {{$cashbackSetting->status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <div class="input-group">
                                <input type="number" class="form-control" name="cashback_percentage"
                                       value="{{$cashbackSetting->cashback_percentage}}"
                                       step="0.01" min="0" max="100" required>
                                <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                            <small class="form-text text-muted">{{translate('Percentage of order amount to give as cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">{{\App\CentralLogics\Helpers::currency_symbol()}}</span>
                                </div>
                                <input type="number" class="form-control" name="minimum_order_amount"
                                       value="{{$cashbackSetting->minimum_order_amount}}"
                                       step="0.01" min="0" required>
                            </div>
                            <small class="form-text text-muted">{{translate('Minimum order value to earn cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">{{\App\CentralLogics\Helpers::currency_symbol()}}</span>
                                </div>
                                <input type="number" class="form-control" name="maximum_cashback_amount"
                                       value="{{$cashbackSetting->maximum_cashback_amount}}"
                                       step="0.01" min="0" placeholder="{{translate('Leave empty for no limit')}}">
                            </div>
                            <small class="form-text text-muted">{{translate('Maximum cashback limit per order')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" {{$cashbackSetting->wallet_discount_status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <div class="input-group">
                                <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                       value="{{$cashbackSetting->wallet_discount_max_percentage}}"
                                       step="0.01" min="0" max="50" required>
                                <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                            <small class="form-text text-muted">{{translate('Maximum wallet balance usable as discount (up to 50%)')}}</small>
                        </div>
                    </div>
                </div>

                <!-- Preview Section -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="card-title mb-3">
                                    <i class="tio-visible"></i>
                                    {{translate('Settings Preview')}}
                                </h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <strong>{{translate('Cashback Example')}}:</strong>
                                            <br>
                                            <span class="text-muted">
                                                {{translate('Order of')}}
                                                <span class="preview-order-amount">{{\App\CentralLogics\Helpers::set_symbol(500)}}</span>
                                                {{translate('will earn')}}
                                                <span class="preview-cashback text-success font-weight-bold"></span>
                                                {{translate('cashback')}}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <strong>{{translate('Wallet Discount Example')}}:</strong>
                                            <br>
                                            <span class="text-muted">
                                                {{translate('Up to')}}
                                                <span class="preview-wallet-discount text-info font-weight-bold"></span>
                                                {{translate('discount from wallet on order of')}}
                                                <span class="preview-order-amount">{{\App\CentralLogics\Helpers::set_symbol(500)}}</span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="btn-toolbar justify-content-between mt-4">
                    <a href="{{route('branch.cashback.index')}}" class="btn btn-outline-secondary">
                        <i class="tio-arrow-backward"></i>
                        {{translate('Back to Settings')}}
                    </a>
                    <div>
                        <button type="button" class="btn btn-outline-danger me-2" onclick="confirmDelete()">
                            <i class="tio-delete-outlined"></i>
                            {{translate('Delete Settings')}}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="tio-save"></i>
                            {{translate('Update Settings')}}
                        </button>
                    </div>
                </div>
            </form>
            @else
            <div class="alert alert-warning text-center">
                <i class="tio-warning text-warning" style="font-size: 3rem;"></i>
                <h5 class="mt-2">{{translate('No Settings Found')}}</h5>
                <p>{{translate('No cashback settings found for your branch.')}}</p>
                <a href="{{route('branch.cashback.index')}}" class="btn btn-primary">
                    {{translate('Create Settings')}}
                </a>
            </div>
            @endif
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{translate('Confirm Delete')}}</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>{{translate('Are you sure you want to delete the cashback settings? This action cannot be undone.')}}</p>
                    <div class="alert alert-warning">
                        <i class="tio-warning"></i>
                        {{translate('Deleting will disable all cashback and wallet discount features for your branch.')}}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{translate('Cancel')}}</button>
                    <form action="{{route('branch.cashback.delete')}}" method="post" class="d-inline">
                        @csrf
                        @method('delete')
                        <button type="submit" class="btn btn-danger">{{translate('Delete Settings')}}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Update preview when values change
    function updatePreview() {
        let cashbackPercentage = parseFloat($('input[name="cashback_percentage"]').val()) || 0;
        let walletPercentage = parseFloat($('input[name="wallet_discount_max_percentage"]').val()) || 0;
        let maxCashback = parseFloat($('input[name="maximum_cashback_amount"]').val()) || null;

        let orderAmount = 500;
        let cashbackAmount = (orderAmount * cashbackPercentage / 100);

        if (maxCashback && cashbackAmount > maxCashback) {
            cashbackAmount = maxCashback;
        }

        let walletDiscountAmount = (orderAmount * walletPercentage / 100);

        $('.preview-cashback').text('{{\App\CentralLogics\Helpers::currency_symbol()}}' + cashbackAmount.toFixed(2));
        $('.preview-wallet-discount').text('{{\App\CentralLogics\Helpers::currency_symbol()}}' + walletDiscountAmount.toFixed(2));
    }

    // Update preview on input change
    $('input[name="cashback_percentage"], input[name="maximum_cashback_amount"], input[name="wallet_discount_max_percentage"]')
        .on('input', updatePreview);

    // Initial preview update
    updatePreview();

    $('[data-toggle="tooltip"]').tooltip();
});

function confirmDelete() {
    $('#deleteModal').modal('show');
}
</script>
@endsection
