<link rel="stylesheet" href="https://cdn.datatables.net/1.11.1/css/jquery.dataTables.min.css">

<table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100 mt-3" id="datatable">
    <thead class="thead-light">
        <tr>
            <th>{{translate('SL')}} </th>
             <th>Customer Name</th>
            <th>Customer Phone</th>
            <th>{{translate('order')}}</th>
             <th>Order Code</th>
            <th>{{translate('date')}}</th>
            <th>{{translate('qty')}}</th>
            <th>Amount</th>
             <th> Tax</th>
            <th>Discount</th>
             <th>Shipping</th>
            <th>Total Amount</th>
        </tr>
    </thead>
    <tbody>
    @foreach($data as $key=>$row)
        <tr>
            <td class="">
                {{$key+1}}
            </td>
             <td>@if($row['customer_name']){{$row['customer_name']}}@else {{'Walk In'}} @endif</td>
             <td>{{$row['customer_phone']}}</td>
            <td class="">
                <a href="{{route('branch.orders.details',['id'=>$row['order_id']])}}">{{$row['order_id']}}</a>
            </td>
            <td class="">
                <a href="{{route('branch.orders.details',['id'=>$row['order_id']])}}">{{$row['order_code']}}</a>
            </td>
            <td>{{date('d M Y',strtotime($row['date']))}}</td>
            <td>{{$row['quantity']}}</td>
            <td>{{$row['item_total']}}</td>
            <td>{{$row['total_tax_amount']}}</td>
            <td>{{$row['coupon_discount_amount']+$row['extra_discount']}}</td>
            <td>{{$row['shipping_charge']}}</td>
           <td>{{ $row['price']+$row['shipping_charge'] }}</td>
        </tr>
    @endforeach
    </tbody>
</table>

<script type="text/javascript">
    $(document).ready(function () {
        $('input').addClass('form-control');
    });
    var datatable = $.HSCore.components.HSDatatables.init($('#datatable'), {
        dom: 'Bfrtip',
        "iDisplayLength": 25,
    });
</script>
