<?php $__env->startSection('title', translate('Map API Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/third-party.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('third_party')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._3rdparty-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.third-party.map_api_settings'):'javascript:'); ?>" method="post"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <?php ($serverKey=\App\Model\BusinessSetting::where('key','map_api_server_key')->first()?->value ); ?>
                                <div class="form-group col-md-6">
                                    <label class="form-label"><?php echo e(translate('map_api_server')); ?> <?php echo e(translate('key')); ?></label>
                                    <textarea name="map_api_server_key" class="form-control"><?php echo e(env('APP_MODE')!='demo'?$serverKey:''); ?></textarea>
                                </div>
                                <?php ($clientKey=\App\Model\BusinessSetting::where('key','map_api_client_key')->first()?->value); ?>
                                <div class="form-group col-md-6">
                                    <label class="form-label"><?php echo e(translate('map_api_client')); ?> <?php echo e(translate('key')); ?></label>
                                    <textarea name="map_api_client_key" class="form-control"><?php echo e(env('APP_MODE')!='demo'?$clientKey:''); ?></textarea>
                                </div>
                            </div>
                            <div class="btn--container mt-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn-primary call-demo"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/map-api.blade.php ENDPATH**/ ?>