<?php $__env->startSection('title', translate('Product Preview')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap justify-content-between gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/bulk_import.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(Str::limit($product['name'], 30)); ?>

                </span>
            </h2>

            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-primary">
                <i class="tio-back-ui"></i> <?php echo e(translate('back')); ?>

            </a>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <div class="row align-items-md-center g-3">
                    <div class="col-md-5 d-flex justify-content-center">
                        <div class="d-flex align-items-center">
                            <img class="avatar avatar-xxl avatar-4by3 mr-4"
                                 src="<?php echo e($product['imageFullPath']); ?>"
                                 alt="Image Description">
                            <div class="d-block">
                                <h4 class="display-2 text-dark mb-0">
                                    <span class="c1"><?php echo e(count($product->rating)>0?number_format($product->rating[0]->average, 1, '.', ' '):0); ?></span><span class="text-muted">/5</span>
                                </h4>
                                <p> <?php echo e(translate('of')); ?> <?php echo e($product->reviews->count()); ?> <?php echo e(translate('reviews')); ?>

                                    <span class="badge badge-soft-dark badge-pill ml-1"></span>
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-7">
                        <ul class="list-unstyled list-unstyled-py-2 mb-0">

                        <?php ($total=$product->reviews->count()); ?>
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($five=\App\CentralLogics\Helpers::rating_count($product['id'],5)); ?>
                                <span
                                    class="progress-name"><?php echo e(translate('Excellent')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($five/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($five/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="ml-3"><?php echo e($five); ?></span>
                            </li>

                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($four=\App\CentralLogics\Helpers::rating_count($product['id'],4)); ?>
                                <span class="progress-name"><?php echo e(translate('Good')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($four/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($four/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="ml-3"><?php echo e($four); ?></span>
                            </li>

                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($three=\App\CentralLogics\Helpers::rating_count($product['id'],3)); ?>
                                <span class="progress-name"><?php echo e(translate('Average')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($three/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($three/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="ml-3"><?php echo e($three); ?></span>
                            </li>

                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($two=\App\CentralLogics\Helpers::rating_count($product['id'],2)); ?>
                                <span class="progress-name"><?php echo e(translate('Below_Average')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($two/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($two/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="ml-3"><?php echo e($two); ?></span>
                            </li>

                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($one=\App\CentralLogics\Helpers::rating_count($product['id'],1)); ?>
                                <span class="progress-name"><?php echo e(translate('Poor')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($one/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($one/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="ml-3"><?php echo e($one); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3 mb-lg-5">
            <div class="">
                <div class="table-responsive">
                    <table class="table table-borderless table-thead-bordered table-nowrap card-table">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo e(translate('Short_Description')); ?></th>
                                <th><?php echo e(translate('Price')); ?></th>
                                <th><?php echo e(translate('Variations')); ?></th>
                                <th><?php echo e(translate('Addons')); ?></th>
                                <th><?php echo e(translate('Tags')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="max-w300 text-wrap">
                                        <div class="d-block text-break text-dark __descripiton-txt __not-first-hidden" id="__descripiton-txt-des<?php echo e($product->id); ?>">
                                            <div>
                                                <?php echo $product['description']; ?>

                                            </div>
                                            <div class="show-more text-info text-center">
                                                <span id="show-more-des<?php echo e($product->id); ?>"
                                                      data-id="-des<?php echo e($product->id); ?>"
                                                      class="see-more"><?php echo e(translate('See More')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-column gap-2">
                                        <div><strong><?php echo e(translate('Price')); ?> :</strong> <?php echo e(\App\CentralLogics\Helpers::set_symbol($product['price'])); ?></div>
                                        <div><strong><?php echo e(translate('tax')); ?> :</strong> <?php echo e(\App\CentralLogics\Helpers::set_symbol(\App\CentralLogics\Helpers::tax_calculate($product,$product['price']))); ?></div>
                                        <div><strong><?php echo e(translate('Discount')); ?> :</strong> <?php echo e(\App\CentralLogics\Helpers::set_symbol(\App\CentralLogics\Helpers::discount_calculate($product,$product['price']))); ?></div>
                                        <div><strong><?php echo e(translate('Available_Time_Start')); ?> :</strong> <?php echo e(date(config('time_format'), strtotime($product['available_time_starts']))); ?></div>
                                        <div><strong><?php echo e(translate('Available_Time_End')); ?> :</strong> <?php echo e(date(config('time_format'), strtotime($product['available_time_ends']))); ?></div>
                                    </div>
                                </td>
                                <td class="px-4">
                                    <?php $__currentLoopData = json_decode($product->variations,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($variation["price"])): ?>
                                            <span class="d-block mb-1 text-capitalize">
                                                <strong><?php echo e(translate('please_update_the_product_variations.')); ?></strong>
                                            </span>
                                        <?php break; ?>
                                        <?php else: ?>
                                            <span class="d-block text-capitalize">
                                                <strong><?php echo e($variation['name']); ?> -</strong>
                                                <?php if($variation['type'] == 'multi'): ?>
                                                    <?php echo e(translate('multiple_select')); ?>

                                                <?php elseif($variation['type'] =='single'): ?>
                                                    <?php echo e(translate('single_select')); ?>

                                                <?php endif; ?>
                                                <?php if($variation['required'] == 'on'): ?>
                                                    - (<?php echo e(translate('required')); ?>)
                                                <?php endif; ?>
                                            </span>

                                            <?php if($variation['min'] != 0 && $variation['max'] != 0): ?>
                                                (<?php echo e(translate('Min_select')); ?>: <?php echo e($variation['min']); ?> - <?php echo e(translate('Max_select')); ?>: <?php echo e($variation['max']); ?>)
                                            <?php endif; ?>

                                            <?php if(isset($variation['values'])): ?>
                                                <?php $__currentLoopData = $variation['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="d-block text-capitalize">
                                                        <?php echo e($value['label']); ?> :<strong><?php echo e(\App\CentralLogics\Helpers::set_symbol( $value['optionPrice'])); ?></strong>
                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td>
                                    <div class="d-flex flex-column gap-1">
                                        <?php $__currentLoopData = \App\Model\AddOn::whereIn('id',json_decode($product['add_ons'],true))->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-capitalize">
                                            <strong><?php echo e($addon['name']); ?> :</strong> <?php echo e(\App\CentralLogics\Helpers::set_symbol($addon['price'])); ?>

                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </td>
                                <td>
                                    <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge-soft-success mb-1 mr-1 d-inline-block px-2 py-1 rounded"><?php echo e($tag->tag); ?> </span> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="table-top p-3">
                <h5 class="mb-0"><?php echo e(translate('Product_Reviews')); ?></h5>
            </div>
            <div class="table-responsive datatable-custom">
                <table id="datatable" class="table table-borderless table-thead-bordered table-nowrap card-table"
                       data-hs-datatables-options='{
                     "columnDefs": [{
                        "targets": [0, 3, 6],
                        "orderable": false
                      }],
                     "order": [],
                     "info": {
                       "totalQty": "#datatableWithPaginationInfoTotalQty"
                     },
                     "search": "#datatableSearch",
                     "entries": "#datatableEntries",
                     "pageLength": 25,
                     "isResponsive": false,
                     "isShowPaging": false,
                     "pagination": "datatablePagination"
                   }'>
                    <thead class="thead-light">
                        <tr>
                            <th><?php echo e(translate('reviewer')); ?></th>
                            <th><?php echo e(translate('review')); ?></th>
                            <th><?php echo e(translate('image')); ?></th>
                            <th><?php echo e(translate('date')); ?></th>
                        </tr>
                    </thead>

                    <tbody>

                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <a class="d-flex align-items-center"
                                   href="<?php echo e(route('admin.customer.view',[$review['user_id']])); ?>">
                                    <div class="avatar avatar-circle">
                                        <?php if($review->customer): ?>
                                            <img class="avatar-img" width="75" height="75"
                                                 src="<?php echo e($review->customer->imageFullPath); ?>"
                                                 alt="">
                                        <?php else: ?>
                                            <img class="avatar-img" width="75" height="75"
                                                 src="<?php echo e(asset('public/assets/admin/img/160x160/img1.jpg')); ?>"
                                                 alt="">
                                        <?php endif; ?>

                                    </div>
                                    <div class="ml-3">
                                    <span class="d-block h5 text-hover-primary mb-0">
                                        <?php if(isset($review->customer)): ?>
                                        <?php echo e($review->customer['f_name']." ".$review->customer['l_name']); ?>

                                        <i class="tio-verified text-primary" data-toggle="tooltip" data-placement="top"
                                            title="Verified Customer"></i></span>
                                        <span class="d-block font-size-sm text-body"><?php echo e($review->customer->email); ?></span>
                                        <?php else: ?>
                                            <span class="badge-pill badge-soft-dark text-muted text-sm small">
                                                <?php echo e(translate('Customer unavailable')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </td>
                            <td>
                                <div class="text-wrap width-18rem">
                                    <div class="d-flex mb-2">
                                        <label class="badge badge-soft-info">
                                            <?php echo e($review->rating); ?> <i class="tio-star"></i>
                                        </label>
                                    </div>

                                    <div class="max-w300 text-wrap">
                                        <div class="d-block text-break text-dark __descripiton-txt __not-first-hidden" id="__descripiton-txt<?php echo e($review->id); ?>">
                                            <div>
                                                <?php echo $review['comment']; ?>

                                            </div>
                                            <div class="show-more text-info text-center">
                                                <span class="see-more" id="show-more-<?php echo e($review->id); ?>" data-id="<?php echo e($review->id); ?>"><?php echo e(translate('See More')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php $__currentLoopData = json_decode($review['attachment'], true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="avatar avatar-circle">
                                        <img class="cursor-pointer rounded img-fit custom-img-fit image-preview"
                                             src="<?php echo e(asset('storage/app/public/review/'.$image)); ?>"
                                             alt="Image Description">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php echo e(date('d M Y H:i:s',strtotime($review['created_at']))); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="card-footer">
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-12">
                        <?php echo $reviews->links(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        $('.see-more').on('click', function (){
            let id = $(this).data('id');
            showMore(id)
        });
        function showMore(id) {
            $('#__descripiton-txt' + id).toggleClass('__not-first-hidden')
            if($('#show-more' + id).hasClass('active')) {
                $('#show-more' + id).text('<?php echo e(translate('See More')); ?>')
                $('#show-more' + id).removeClass('active')
            }else {
                $('#show-more' + id).text('<?php echo e(translate('See Less')); ?>')
                $('#show-more' + id).addClass('active')
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/product/view.blade.php ENDPATH**/ ?>