<?php $__env->startSection('title', translate('Delivery_Fee_Setup')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('business_setup')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._business-setup-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">
                            <span><?php echo e(translate('General Delivery Fee Setup')); ?></span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.business-settings.restaurant.store-free-delivery-over-amount')); ?>" method="post"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6 mt-5">
                                    <?php
                                    $freeDeliveryStatus=\App\Model\BusinessSetting::where('key','free_delivery_over_amount_status')->latest()->first()->value;
                                    ?>
                                    <div class="form-group">
                                        <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control change-free-delivery-status">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                                <span class="line--limit-1"><strong><?php echo e(translate('free_delivery_over_amount_status')); ?></strong></span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right" data-original-title="<?php echo e(translate('If this field is active and the order amount exceeds this free delivery over amount then the delivery fee will be free.')); ?>"><img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info"></span>
                                            </span>
                                            <input type="checkbox" class="toggle-switch-input" name="free_delivery_status" id="free_delivery_status" <?php echo e($freeDeliveryStatus == 1 ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <?php
                                     $freeDeliveryOverAmount=\App\Model\BusinessSetting::where('key','free_delivery_over_amount')->latest()->first()->value;
                                    ?>
                                    
                                    <div class="form-group mb-0">
                                        <label><?php echo e(translate('free_delivery_over_amount')); ?><span>(<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>)</span>
                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('If the order amount exceeds this amount the delivery fee will be free.')); ?>"></i>

                                        </label>
                                        <input type="number" value="<?php echo e($freeDeliveryOverAmount); ?>" name="free_delivery_over_amount" class="form-control" id="free_delivery_over_amount" placeholder=""
                                               <?php echo e($freeDeliveryStatus == 0 ? 'readonly' : ''); ?> <?php echo e($freeDeliveryStatus == 0 ? 'readonly' : ''); ?> min="0" step="0.01" required>
                                    </div>
                                </div>
                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn--primary call-demo"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>

<br>
        <h4><?php echo e(translate('Delivery Charge Setup')); ?></h4>
        <ul class="nav nav-tabs" id="branchTabs" role="tablist">
            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item">
                    <a class="nav-link" id="branch<?php echo e($branch->id); ?>-tab" data-toggle="tab" href="#branch<?php echo e($branch->id); ?>" role="tab"
                       aria-controls="branch<?php echo e($branch->id); ?>" aria-selected="<?php echo e($loop->first ? 'true' : 'false'); ?>">
                        <?php echo e($branch->name); ?>

                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        <div class="tab-content" id="branchTabsContent">
            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tab-pane fade" id="branch<?php echo e($branch->id); ?>" role="tabpanel" aria-labelledby="branch<?php echo e($branch->id); ?>-tab">
                    <?php echo $__env->make('admin-views.business-settings.partials.delivery_charge_form', ['branch' => $branch], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>

        $('#free_delivery_status').on('change', function () {
            var $freeDeliveryOverAmountField = $('#free_delivery_over_amount');
            if ($(this).is(':checked')) {
                $freeDeliveryOverAmountField.removeAttr('readonly');
            } else {
                $freeDeliveryOverAmountField.attr('readonly', 'readonly');
            }
        });


        $(document).ready(function() {
            $('#addAreaModal').on('shown.bs.modal', function () {
                $('#areaName').trigger('focus');
            });

            $('[data-toggle="modal"]').on('click', function() {
                var branchId = $(this).data('branch-id');
                $('.branchIdInput').val(branchId);
            });

            $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
                var tabId = $(e.target).attr('href'); // e.g., #branch1
                localStorage.setItem('activeTab', tabId);
            });

            var activeTab = localStorage.getItem('activeTab');
            var defaultTab = '#branch1'; // Default tab to select if the active one is deleted

            if (activeTab && $(activeTab).length) {
                $('#branchTabs a[href="' + activeTab + '"]').tab('show');
            } else {
                $('#branchTabs a[href="' + defaultTab + '"]').tab('show');
            }
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/restaurant/delivery-fee.blade.php ENDPATH**/ ?>