<?php $__env->startSection('title', translate('Order List')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
            <h2 class="h1 mb-0 d-flex align-items-center gap-1">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/all_orders.png')); ?>" alt="">
                <span class="page-header-title">
                <?php echo e(translate($status)); ?> <?php echo e(translate('table')); ?> <?php echo e(translate('Orders')); ?>

                </span>
            </h2>
            <span class="badge badge-soft-dark rounded-50 fz-14"><?php echo e($orders->total()); ?></span>
        </div>

        <div class="card">

            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(url()->current()); ?>" id="form-data" method="GET">
                        <div class="row gy-3 gx-2 align-items-end">
                            <div class="col-12 pb-0">
                                <h4 class="mb-0"><?php echo e(translate('Select Date Range')); ?></h4>
                            </div>
                            <div class="col-md-6 col-lg-4">
                                <div class="form-group mb-0">
                                    <label class="text-dark"><?php echo e(translate('Start Date')); ?></label>
                                    <input type="date" name="from"
                                           value="<?php echo e($from); ?>"
                                           id="from_date" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4">
                                <div class="form-group mb-0">
                                    <label class="text-dark"><?php echo e(translate('End Date')); ?></label>
                                    <input type="date"
                                           value="<?php echo e($to); ?>"
                                           name="to" id="to_date" class="form-control">
                                </div>
                            </div>
                            <div class="col-12 col-lg-4 d-flex gap-2">
                                <button type="reset" class="btn btn-secondary flex-grow-1"><?php echo e(translate('Clear')); ?></button>
                                <button type="submit" class="btn btn-primary flex-grow-1 text-nowrap"><?php echo e(translate('Show_Data')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <?php if($status == 'all'): ?>
                <div class="px-4 mt-4">
                    <div class="row g-2">
                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.list', ['status' => 'confirmed'])); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/confirmed.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('confirmed')); ?></span>
                                    </h6>
                                    <span class="card-title text-107980">
                                        <?php echo e($orderCount['confirmed']); ?>

                            </span>
                                </div>
                            </a>
                        </div>

                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.list', ['status' => 'cooking'])); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/packaging.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('cooking')); ?></span>
                                    </h6>
                                    <span class="card-title text-danger">
                                        <?php echo e($orderCount['cooking']); ?>

                            </span>
                                </div>
                            </a>
                        </div>

                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.list', ['status' => 'done'])); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/out_for_delivery.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('ready_for_serve')); ?></span>
                                    </h6>
                                    <span class="card-title text-00B2BE">
                                        <?php echo e($orderCount['done']); ?>

                            </span>
                                </div>
                            </a>
                        </div>

                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.list', ['status' => 'completed'])); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/delivered.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('completed')); ?></span>
                                    </h6>
                                    <span class="card-title text-success">
                                        <?php echo e($orderCount['completed']); ?>

                            </span>
                                </div>
                            </a>
                        </div>

                        <!-- Static Cancel -->
                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.list', ['status' => 'canceled'])); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/canceled.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('canceled')); ?></span>
                                    </h6>
                                    <span class="card-title text-danger">
                                        <?php echo e($orderCount['canceled']); ?>

                            </span>
                                </div>
                            </a>
                        </div>
                        <!-- Static Cancel -->

                        <div class="col-sm-6 col-lg-4">
                            <a class="order--card h-100" href="<?php echo e(route('branch.table.order.running')); ?>">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="card-subtitle d-flex justify-content-between m-0 align-items-center">
                                        <img src="<?php echo e(asset('public/assets/admin/img/icons/returned.png')); ?>" alt="dashboard" class="oder--card-icon">
                                        <span><?php echo e(translate('on_table')); ?></span>
                                    </h6>
                                    <span class="card-title text-warning">
                                        <?php echo e($orderCount['on_table']); ?>

                            </span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Header -->
            <div class="card-top px-card pt-4">
                <div class="row justify-content-between align-items-center gy-2">
                    <div class="col-sm-8 col-md-6 col-lg-4">
                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                            <div class="input-group">
                                <input id="datatableSearch_" type="search" name="search"
                                       class="form-control"
                                       placeholder="<?php echo e(translate('Search by Order ID, Status,Transaction Reference')); ?>" aria-label="Search"
                                       value="<?php echo e($search); ?>" required autocomplete="off">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(translate('Search')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-sm-4 col-md-6 col-lg-8 d-flex justify-content-end">
                        <div>
                            <button type="button" class="btn btn-outline-primary" data-toggle="dropdown" aria-expanded="false">
                                <i class="tio-download-to"></i>
                                <?php echo e(translate('Export')); ?>

                                <i class="tio-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a type="submit" class="dropdown-item d-flex align-items-center gap-2" href="<?php echo e(route('branch.table.order.export-excel')); ?>">
                                        <img width="14" src="<?php echo e(asset('public/assets/admin/img/icons/excel.png')); ?>" alt="">
                                        <?php echo e(translate('Excel')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="py-4">
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                        <tr>
                            <th><?php echo e(translate('SL')); ?></th>
                            <th><?php echo e(translate('order_ID')); ?></th>
                             <th>Order Code</th>
                            <th><?php echo e(translate('Delivery_Date')); ?></th>
                            <th><?php echo e(translate('Branch')); ?></th>
                            <th><?php echo e(translate('total_Amount')); ?></th>
                            <th><?php echo e(translate('order_Status')); ?></th>
                            <th><?php echo e(translate('order_Type')); ?></th>
                            <th class="text-center"><?php echo e(translate('actions')); ?></th>
                        </tr>
                        </thead>

                        <tbody id="set-rows">
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr class="status-<?php echo e($order['order_status']); ?> class-all">
                                <td class="">
                                    <?php echo e($orders->firstitem()+$key); ?>

                                </td>
                                <td>
                                    <a class="text-dark" href="<?php echo e(route('branch.orders.details',['id'=>$order['id']])); ?>"><?php echo e($order['id']); ?></a>
                                </td>
                                  <td>
                                    <a class="text-dark" href="<?php echo e(route('branch.orders.details',['id'=>$order['id']])); ?>"><?php echo e($order['order_code']); ?></a>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(date('d M Y',strtotime($order['created_at']))); ?>

                                    </div>
                                    <div><?php echo e(date('h:m A',strtotime($order['created_at']))); ?></div>
                                </td>

                                <td><span class="badge-soft-info px-2 py-1 rounded"><?php echo e($order->branch->name); ?></span></td>
                                <td>
                                    <div><?php echo e(\App\CentralLogics\Helpers::set_symbol($order['order_amount'])); ?></div>

                                    <?php if($order->payment_status=='paid'): ?>
                                        <span class="badge badge-soft-success"><?php echo e(translate('paid')); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-soft-danger"><?php echo e(translate('unpaid')); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-capitalize">
                                    <?php if($order['order_status']=='pending'): ?>
                                        <span class="badge-soft-info px-2 py-1 rounded"><?php echo e(translate('pending')); ?></span>
                                    <?php elseif($order['order_status']=='confirmed'): ?>
                                        <span class="badge-soft-info px-2 py-1 rounded"><?php echo e(translate('confirmed')); ?></span>
                                    <?php elseif($order['order_status']=='processing'): ?>
                                        <span class="badge-soft-warning px-2 py-1 rounded"><?php echo e(translate('processing')); ?></span>
                                    <?php elseif($order['order_status']=='out_for_delivery'): ?>
                                        <span class="badge-soft-warning px-2 py-1 rounded"><?php echo e(translate('out_for_delivery')); ?></span>
                                    <?php elseif($order['order_status']=='delivered'): ?>
                                        <span class="badge-soft-success px-2 py-1 rounded"><?php echo e(translate('delivered')); ?></span>
                                    <?php else: ?>
                                        <span class="badge-soft-danger px-2 py-1 rounded"><?php echo e(str_replace('_',' ',$order['order_status'])); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-capitalize">
                                    <?php if($order['order_type']=='take_away'): ?>
                                        <span class="badge-soft-info px-2 rounded"><?php echo e(translate('take_away')); ?></span>
                                    <?php elseif($order['order_type']=='dine_in'): ?>
                                        <span class="badge-soft-info px-2 rounded"><?php echo e(translate('dine_in')); ?></span>
                                    <?php else: ?>
                                        <span class="badge-soft-success px-2 rounded"><?php echo e(translate('delivery')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="d-flex justify-content-center gap-2">
                                        <a class="btn btn-sm btn-outline-info square-btn"
                                           href="<?php echo e(route('branch.orders.details',['id'=>$order['id']])); ?>"><i
                                                class="tio-visible"></i></a>
                                        <button class="btn btn-sm btn-outline-success square-btn print-invoice" target="_blank" type="button"
                                                data-order="<?php echo e($order->id); ?>">
                                            <i class="tio-download"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="table-responsive mt-4 px-3">
                    <div class="d-flex justify-content-lg-end">
                        <?php echo $orders->links(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="print-invoice" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translate('print')); ?> <?php echo e(translate('invoice')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body row" style="font-family: emoji;">
                    <div class="col-md-12">
                        <div class="text-center">
                            <input type="button" class="btn btn-primary non-printable printDiv" data-name="printableArea"
                                   value="<?php echo e(translate('Proceed, If thermal printer is ready.')); ?>"/>
                            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger non-printable"><?php echo e(translate('Back')); ?></a>
                        </div>
                        <hr class="non-printable">
                    </div>
                    <div class="row" id="printableArea" style="margin: auto;">

                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict"

        $(document).on('ready', function () {
            $('.js-select2-custom').each(function () {
                var select2 = $.HSCore.components.HSSelect2.init($(this));
            });
        });

        $('.print-invoice').on('click', function (){
            let orderId = $(this).data('order');
            $.get({
                url: '<?php echo e(url('/')); ?>/branch/pos/invoice/'+orderId,
                dataType: 'json',
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    console.log("success...")
                    $('#print-invoice').modal('show');
                    $('#printableArea').empty().html(data.view);
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        })

        $('.printDiv').on('click', function (){
            let divName = $(this).data('name');

            if($('html').attr('dir') === 'rtl') {
                $('html').attr('dir', 'ltr')
                var printContents = document.getElementById(divName).innerHTML;
                document.body.innerHTML = printContents;
                $('#printableAreaContent').attr('dir', 'rtl')
                window.print();
                $('html').attr('dir', 'rtl')
                location.reload();
            }else{
                var printContents = document.getElementById(divName).innerHTML;
                document.body.innerHTML = printContents;
                window.print();
                location.reload();
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/branch-views/table/order/list.blade.php ENDPATH**/ ?>