<?php $__env->startSection('title', translate('Chef List')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
        <h2 class="h1 mb-0 d-flex align-items-center gap-2">
            <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/cooking.png')); ?>" alt="">
            <span class="page-header-title">
                <?php echo e(translate('Chef_List')); ?>

            </span>
        </h2>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-top px-card pt-4">
                    <div class="row justify-content-between align-items-center gy-2">
                        <div class="col-md-4">
                            <h5 class="d-flex gap-2 mb-0">
                                <?php echo e(translate('chef_Table')); ?>

                                <span class="badge badge-soft-dark rounded-50 fz-12"><?php echo e($chefs->total()); ?></span>
                            </h5>
                        </div>
                        <div class="col-md-8">
                            <div class="d-flex flex-wrap justify-content-md-end gap-3">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group">
                                        <input id="datatableSearch_" type="search" name="search" class="form-control" placeholder="<?php echo e(translate('Search by Name')); ?>" aria-label="Search" value="<?php echo e($search); ?>" required="" autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Search')); ?></button>
                                        </div>
                                    </div>
                                </form>
                                <a href="<?php echo e(route('admin.kitchen.add-new')); ?>" class="btn btn-primary text-nowrap">
                                    <i class="tio-add"></i>
                                    <span class="text"><?php echo e(translate('Add_New')); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="py-4">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(translate('SL')); ?></th>
                                    <th><?php echo e(translate('Name')); ?></th>
                                    <th><?php echo e(translate('Contact_Info')); ?></th>
                                    <th><?php echo e(translate('Branch')); ?></th>
                                    <th><?php echo e(translate('Status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $chefs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$chef): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><span><?php echo e($k+1); ?></span></td>
                                    <td class="text-capitalize"><?php echo e($chef['f_name'] . ' ' . $chef['l_name']); ?></td>
                                    <td>
                                        <div><a class="text-dark" href="mailto:<?php echo e($chef['email']); ?>"><strong><?php echo e($chef['email']); ?></strong></a></div>
                                        <div><a class="text-dark" href="tel:<?php echo e($chef['phone']); ?>"><?php echo e($chef['phone']); ?></a></div>
                                    </td>
                                    <td><?php echo e(\App\User::get_chef_branch_name($chef)); ?></td>
                                    <td>
                                        <label class="switcher">
                                            <input type="checkbox" class="switcher_input redirect-url"
                                                   data-url="<?php echo e(route('admin.kitchen.status',[$chef['id'],$chef->is_active?0:1])); ?>"
                                                   class="toggle-switch-input" <?php echo e($chef->is_active?'checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="d-flex justify-content-center gap-2">
                                            <a href="<?php echo e(route('admin.kitchen.update',[$chef['id']])); ?>"
                                            class="btn btn-outline-info btn-sm square-btn"
                                            title="<?php echo e(translate('Edit')); ?>">
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="btn btn-outline-danger btn-sm square-btn form-alert" title="<?php echo e(translate('Delete')); ?>" href="javascript:"
                                            data-id="chef-<?php echo e($chef['id']); ?>" data-message="<?php echo e(translate('Want to delete this chef ?')); ?>">
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                        <form action="<?php echo e(route('admin.kitchen.delete',[$chef['id']])); ?>"
                                              method="post" id="chef-<?php echo e($chef['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4 px-3">
                        <div class="d-flex justify-content-lg-end">
                            <?php echo e($chefs->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        "use strict";

        $(document).ready(function () {
            $('#dataTable').DataTable();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/kitchen/list.blade.php ENDPATH**/ ?>