<?php $__env->startSection('title', translate('Settings')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <script src="https://use.fontawesome.com/74721296a6.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/cloud-database.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('system_setup')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._system-settings-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row g-2">
            <div class="col-12">
                <div class="alert alert--danger alert-danger mb-3" role="alert">
                    <i class="tio-info alert--icon"></i> <strong><?php echo e(translate('Note :')); ?></strong>
                    <?php echo e(translate('This_page_contains_sensitive_information.Make_sure_before_changing.')); ?>

                </div>

                <form action="<?php echo e(route('admin.business-settings.web-app.system-setup.clean-db')); ?>" method="post"
                        enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="check--item-wrapper clean--database-checkgroup mt-0">
                                <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="check-item">
                                        <div class="form-group form-check">
                                            <input type="checkbox" name="tables[]" value="<?php echo e($table); ?>"
                                                class="form-check-input"
                                                id="business_section_<?php echo e($key); ?>">
                                            <label class="form-check-label text-dark" for="business_section_<?php echo e($key); ?>"><?php echo e(Str::limit(translate($table), 20)); ?></label>
                                            <span class="badge-pill badge-secondary fz-12 ml-2"><?php echo e($rows[$key]); ?></span>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div class="btn--container mt-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn-primary call-demo"><?php echo e(translate('Clean')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).ready(function () {
            $("#purchase_code_div").click(function () {
                var type = $('#purchase_code').get(0).type;
                if (type === 'password') {
                    $('#purchase_code').get(0).type = 'text';
                } else if (type === 'text') {
                    $('#purchase_code').get(0).type = 'password';
                }
            });
        })
    </script>

    <script>
        $("form").on('submit',function(e) {
            e.preventDefault();
            Swal.fire({
                title: '<?php echo e(translate('Are you sure?')); ?>',
                text: "<?php echo e(translate('Sensitive_data! Make_sure_before_changing.')); ?>",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#FC6A57',
                cancelButtonColor: 'default',
                cancelButtonText: '<?php echo e(translate('No?')); ?>',
                confirmButtonText:'<?php echo e(translate('Yes?')); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    this.submit();
                }else{
                    e.preventDefault();
                    toastr.success("<?php echo e(translate('Cancelled')); ?>");
                    location.reload();
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/db-index.blade.php ENDPATH**/ ?>