<?php $__env->startSection('title', translate('Product update')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/product.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Update Product Price')); ?>

                </span>
            </h2>
        </div>

        <form action="javascript:" method="post" id="set_price_form" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <?php ($productByBranch = json_decode($product->product_by_branch, true)); ?>
            <?php
            if(isset($productByBranch[0])){
                $price = $productByBranch[0]['price'];
                $discountType = $productByBranch[0]['discount_type'];
                $discount = $productByBranch[0]['discount'];
            }else{
                $price = $product['price'];
                $discountType = $product['discount_type'];
                $discount = $product['discount'];
            }
            ?>

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="mb-0 d-flex gap-2 align-items-center">
                                <i class="tio-premium"></i>
                                <?php echo e(translate('Product Information')); ?>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="card p-4" id="">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(translate('name')); ?> (EN)</label>
                                    <input type="text" name="" value="<?php echo e($product['name']); ?>" class="form-control" placeholder="<?php echo e(translate('Product Name')); ?>" readonly required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <h4 class="mb-0 d-flex gap-2 align-items-center">
                                <i class="tio-dollar"></i>
                                <?php echo e(translate('Stock Information')); ?>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Stock Type')); ?></label>
                                        <select name="stock_type" class="form-control js-select2-custom" id="stock_type">
                                            <?php if($product->sub_branch_product): ?>
                                                <option value="unlimited" <?php echo e($product->sub_branch_product?->stock_type == 'unlimited' ? 'selected' : ''); ?>><?php echo e(translate('unlimited')); ?></option>
                                                <option value="daily" <?php echo e($product->sub_branch_product?->stock_type == 'daily' ? 'selected' : ''); ?>><?php echo e(translate('daily')); ?></option>
                                                <option value="fixed" <?php echo e($product->sub_branch_product?->stock_type == 'fixed' ? 'selected' : ''); ?>><?php echo e(translate('Fixed')); ?></option>
                                            <?php else: ?>
                                                <option value="unlimited" <?php echo e($mainBranchProduct?->stock_type == 'unlimited' ? 'selected' : ''); ?>><?php echo e(translate('unlimited')); ?></option>
                                                <option value="daily" <?php echo e($mainBranchProduct?->stock_type == 'daily' ? 'selected' : ''); ?>><?php echo e(translate('daily')); ?></option>
                                                <option value="fixed" <?php echo e($mainBranchProduct?->stock_type == 'fixed' ? 'selected' : ''); ?>><?php echo e(translate('Fixed')); ?></option>
                                            <?php endif; ?>

                                        </select>
                                    </div>
                                </div>
                                <?php
                                $stock = $product->sub_branch_product?->stock ?? $mainBranchProduct?->stock ?? null;

                                ?>
                                <div class="col-sm-6 d-none" id="product_stock_div">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Product Stock')); ?></label>
                                        <input id="product_stock" type="number" name="product_stock" class="form-control"
                                               value="<?php echo e($stock); ?>" placeholder="<?php echo e(translate('Ex : 10')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card h-100 mt-3">
                        <div class="card-header">
                            <h4 class="mb-0 d-flex gap-2 align-items-center">
                                <i class="tio-dollar"></i>
                                <?php echo e(translate('Price_Information')); ?>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-4">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('default_Price')); ?></label>
                                        <input type="number" value="<?php echo e($price); ?>" min="0.1" name="price" class="form-control" step="0.01"
                                               placeholder="<?php echo e(translate('Ex : 100')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('discount_Type')); ?></label>
                                        <select name="discount_type" class="form-control js-select2-custom">
                                            <option value="percent" <?php echo e($discountType =='percent'?'selected':''); ?>><?php echo e(translate('percent')); ?></option>
                                            <option value="amount" <?php echo e($discountType =='amount'?'selected':''); ?>><?php echo e(translate('amount')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('discount')); ?></label>
                                        <input type="number" min="0" value="<?php echo e($discount); ?>"
                                               name="discount" class="form-control" required placeholder="Ex : 100">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-2">
                <div class="col-12">
                    <div class="card mt-5">
                        <div class="card-header">
                            <h4 class="mb-0 d-flex gap-2 align-items-center">
                                <i class="tio-canvas-text"></i>
                                <?php echo e(translate('product_variations')); ?>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="row g-2">
                                <div class="col-md-12" >
                                    <div id="add_new_option">
                                        <?php if(isset($product->product_by_branch) && count($product->product_by_branch)): ?>
                                            <?php $__currentLoopData = $product->product_by_branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $__empty_1 = true; $__currentLoopData = $branch_product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_choice_options=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <?php echo $__env->make('branch-views.product.partials._new_variations',['item'=>$item,'key'=>$key_choice_options+1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <h5 class="text-center"><?php echo e(translate('This product has no variation')); ?></h5>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php if(isset($product->variations)): ?>
                                                <?php $__empty_1 = true; $__currentLoopData = json_decode($product->variations,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_choice_options=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <?php if(isset($item["price"])): ?>
                                                        <h5 class="text-center"><?php echo e(translate('This product have old variation, please update variation first')); ?></h5>
                                                        <?php break; ?>
                                                    <?php else: ?>
                                                        <?php echo $__env->make('branch-views.product.partials._new_variations',['item'=>$item,'key'=>$key_choice_options+1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <h5 class="text-center"><?php echo e(translate('This product has no variation')); ?></h5>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end gap-3 mt-4">
                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo e(translate('update')); ?></button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        function show_min_max(data){
            $('#min_max1_'+data).removeAttr("readonly");
            $('#min_max2_'+data).removeAttr("readonly");
            $('#min_max1_'+data).attr("required","true");
            $('#min_max2_'+data).attr("required","true");
        }
        function hide_min_max (data){
            $('#min_max1_'+data).val(null).trigger('change');
            $('#min_max2_'+data).val(null).trigger('change');
            $('#min_max1_'+data).attr("readonly","true");
            $('#min_max2_'+data).attr("readonly","true");
            $('#min_max1_'+data).attr("required","false");
            $('#min_max2_'+data).attr("required","false");
        }

        $('#set_price_form').on('submit', function () {
            var formData = new FormData(this);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('branch.product.set-price-update',[$product['id']])); ?>',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    if (data.errors) {
                        for (var i = 0; i < data.errors.length; i++) {
                            toastr.error(data.errors[i].message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        }
                    } else {
                        toastr.success('<?php echo e(translate("product updated successfully!")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function () {
                            location.href = '<?php echo e(route('branch.product.list')); ?>';
                        }, 2000);
                    }
                }
            });
        });

        <?php if($product->sub_branch_product): ?>
        <?php ($stock = $product->sub_branch_product?->stock ?? null); ?>
        <?php if($stock == 'daily' || $stock == 'fixed'): ?>
        $("#product_stock_div").removeClass('d-none')
        <?php endif; ?>
        <?php else: ?>
        <?php ($stock = $mainBranchProduct?->stock ?? null); ?>

        <?php if($stock == 'daily' || $stock == 'fixed'): ?>
        $("#product_stock_div").removeClass('d-none')
        <?php endif; ?>
        <?php endif; ?>


        $("#stock_type").change(function(){
            if(this.value === 'daily' || this.value === 'fixed') {
                $("#product_stock_div").removeClass('d-none')
            }
            else {
                $("#product_stock_div").addClass('d-none')
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/branch-views/product/set-price.blade.php ENDPATH**/ ?>