<?php $__env->startSection('title', translate('OTP setup')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('business_setup')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._business-setup-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.business-settings.restaurant.otp-setup-update')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <?php ($maximumOTPHit=\App\Model\BusinessSetting::where('key','maximum_otp_hit')->first()?->value); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label text-capitalize"><?php echo e(translate('maximum_OTP_submit_attempt')); ?>

                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('The maximum OTP hit is a measure of how many times a specific one-time password has been generated and used within a time.')); ?>">
                                            </i>
                                        </label>
                                        <input type="number" value="<?php echo e($maximumOTPHit); ?>" min="1"
                                               name="maximum_otp_hit" class="form-control" required>
                                    </div>
                                </div>

                                <?php ($OTPResendTime=\App\Model\BusinessSetting::where('key','otp_resend_time')->first()?->value); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label text-capitalize"><?php echo e(translate('otp_resend_time')); ?>

                                            <span class="text-danger">( <?php echo e(translate('in second')); ?> )</span>
                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('If the user fails to get the OTP within a certain time, user can request a resend.')); ?>">
                                            </i>
                                        </label>
                                        <input type="number" value="<?php echo e($OTPResendTime); ?>" min="1"
                                               name="otp_resend_time" class="form-control" required>
                                    </div>
                                </div>

                                <?php ($temporaryBlockTime=\App\Model\BusinessSetting::where('key','temporary_block_time')->first()?->value); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label text-capitalize"><?php echo e(translate('temporary_block_time')); ?>

                                            <span class="text-danger">( <?php echo e(translate('in second')); ?> )</span>
                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('Temporary OTP block time refers to a security measure implemented by systems to restrict access to OTP service for a specified period of time for wrong OTP submission.')); ?>">
                                            </i>
                                        </label>
                                        <input type="number" value="<?php echo e($temporaryBlockTime); ?>" min="1"
                                               name="temporary_block_time" class="form-control" required>
                                    </div>
                                </div>

                                <?php ($maximumLoginHit=\App\Model\BusinessSetting::where('key','maximum_login_hit')->first()?->value); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label text-capitalize"><?php echo e(translate('maximum_login_attempt')); ?>

                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('The maximum login hit is a measure of how many times a user can submit password within a time.')); ?>">
                                            </i>
                                        </label>
                                        <input type="number" value="<?php echo e($maximumLoginHit); ?>" min="1"
                                               name="maximum_login_hit" class="form-control" required>
                                    </div>
                                </div>

                                <?php ($temporaryLoginBlockTime=\App\Model\BusinessSetting::where('key','temporary_login_block_time')->first()?->value); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label text-capitalize"><?php echo e(translate('temporary_login_block_time')); ?>

                                            <span class="text-danger">( <?php echo e(translate('in second')); ?> )</span>
                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('Temporary login block time refers to a security measure implemented by systems to restrict access for a specified period of time for wrong Password submission.')); ?>">
                                            </i>
                                        </label>
                                        <input type="number" value="<?php echo e($temporaryLoginBlockTime); ?>" min="1"
                                               name="temporary_login_block_time" class="form-control" required>
                                    </div>
                                </div>
                            </div>

                            <div class="btn--container mt-4">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn-primary call-demo"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/otp-setup.blade.php ENDPATH**/ ?>