<?php $__env->startSection('title', translate('Business Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('business_setup')); ?>

                </span>
            </h2>
        </div>

        <form action="<?php echo e(route('branch.business-settings.update')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card mb-3">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 col-sm-6">
                            <div class="form-group">
                                <label class="input-label text-capitalize"><?php echo e(translate('Branch Name')); ?></label>
                                <input value="<?php echo e($branch['name']); ?>" type="text" name="name"  maxlength="255" class="form-control"
                                       placeholder="<?php echo e(translate('Ex: ABC Branch')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-6">
                            <div class="form-group">
                                <label class="input-label text-capitalize"><?php echo e(translate('preparation_time')); ?><span class="text-danger mx-1">*</span>
                                    <i class="tio-info-outined"
                                       data-toggle="tooltip"
                                       data-placement="top"
                                       title="<?php echo e(translate('Food preparation time will show to customer.')); ?>">
                                    </i>
                                </label>
                                <input value="<?php echo e($branch['preparation_time']); ?>" type="number" name="preparation_time" class="form-control"
                                       placeholder=" Ex: <?php echo e(translate('30')); ?>" min="1" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="btn--container mt-4">
                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn-primary call-demo"><?php echo e(translate('submit')); ?></button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/branch-views/business-settings/branch-index.blade.php ENDPATH**/ ?>