<?php $__env->startSection('title', translate('Update Notification')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <i class="tio-notifications"></i>
                <span class="page-header-title">
                    <?php echo e(translate('notification_Update')); ?>

                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <form action="<?php echo e(route('admin.notification.update',[$notification['id']])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('title')); ?>

                                            <i class="tio-info text-danger" data-toggle="tooltip" data-placement="right"
                                               title="<?php echo e(translate('not_more_than_100_characters')); ?>">
                                            </i>
                                        </label>                                        <input type="text" value="<?php echo e($notification['title']); ?>" name="title" class="form-control" placeholder="<?php echo e(translate('New notification')); ?>" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('description')); ?>

                                            <i class="tio-info text-danger" data-toggle="tooltip" data-placement="right"
                                               title="<?php echo e(translate('not_more_than_255_characters')); ?>">
                                            </i>
                                        </label>
                                        <textarea name="description" class="form-control" rows="3" required><?php echo e($notification['description']); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                            <label class="mb-0"><?php echo e(translate('image')); ?></label>
                                            <small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 3:1 )</small>
                                        </div>
                                        <div class="d-flex justify-content-center mt-4">
                                            <div class="upload-file">
                                                <input type="file" name="image" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" class="upload-file__input">
                                                <div class="upload-file__img_drag upload-file__img max-h-200px overflow-hidden">
                                                    <img width="465" src="<?php echo e($notification['imageFullPath']); ?>" alt="<?php echo e(translate('notification')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/read-url.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/notification/edit.blade.php ENDPATH**/ ?>