<?php $__env->startSection('title', translate('Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/third-party.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('third_party')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._3rdparty-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center gap-3">
                            <button class="btn btn-secondary" type="button" data-toggle="collapse"
                                    data-target="#collapseExample" aria-expanded="false"
                                    aria-controls="collapseExample">
                                <i class="tio-email-outlined"></i>
                                <?php echo e(translate('test_your_email_integration')); ?>

                            </button>
                            <div class="">
                                <i class="tio-telegram"></i>
                            </div>
                        </div>

                        <div class="collapse" id="collapseExample">
                            <div class="pt-3">
                                <form class="" action="javascript:">
                                    <div class="d-flex gap-3">
                                        <div class="flex-grow-1">
                                            <label for="inputPassword2"
                                                    class="sr-only"><?php echo e(translate('mail')); ?></label>
                                            <input type="email" id="test-email" class="form-control"
                                                    placeholder="<?php echo e(translate('Ex : jhon@email.com')); ?>">
                                        </div>
                                        <button type="button" class="btn btn-primary send-mail">
                                            <i class="tio-telegram"></i>
                                            <span class="d-none d-sm-inline-block"><?php echo e(translate('send_Mail')); ?></span>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php ($data= \App\CentralLogics\Helpers::get_business_settings('mail_config')); ?>
            <div class="col-12">
                <form action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.mail-config'):'javascript:'); ?>" method="post"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php if(isset($data)): ?>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex flex-wrap mb-3">
                                    <label class="control-label h3 mb-0 text-capitalize mr-3"><?php echo e(translate('Mail Configuration  Status')); ?></label>
                                    <div class="custom--switch">
                                        <input type="checkbox" name="status" value="" id="smtp-mail" switch="primary" class="toggle-switch-input" <?php echo e(isset($data['status']) && $data['status']==1 ? 'checked' : ''); ?>>
                                        <label for="smtp-mail" data-on-label="on" data-off-label="off"></label>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('mailer_name')); ?></label>
                                        <input type="text" placeholder="<?php echo e(translate('ex : Alex')); ?>" class="form-control" name="name"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['name']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('host')); ?></label>
                                        <input type="text" class="form-control" name="host" value="<?php echo e(env('APP_MODE')!='demo'?$data['host']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('driver')); ?></label>
                                        <input type="text" class="form-control" name="driver" value="<?php echo e(env('APP_MODE')!='demo'?$data['driver']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('port')); ?></label>
                                        <input type="text" class="form-control" name="port" value="<?php echo e(env('APP_MODE')!='demo'?$data['port']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('username')); ?></label>
                                        <input type="text" placeholder="<?php echo e(translate('ex : ex@yahoo.com')); ?>" class="form-control" name="username"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['username']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('email')); ?> <?php echo e(translate('id')); ?></label>
                                        <input type="text" placeholder="<?php echo e(translate('ex : ex@yahoo.com')); ?>" class="form-control" name="email"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['email_id']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('encryption')); ?></label>
                                        <input type="text" placeholder="<?php echo e(translate('ex : tls')); ?>" class="form-control" name="encryption"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['encryption']:''); ?>" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <label><?php echo e(translate('password')); ?></label>
                                        <input type="text" class="form-control" name="password" value="<?php echo e(env('APP_MODE')!='demo'?$data['password']:''); ?>" required>
                                    </div>
                                </div>
                                <div class="btn--container mt-3">
                                    <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                    <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                            class="btn btn-primary call-demo"><?php echo e(translate('save')); ?></button>
                                </div>
                            <?php else: ?>
                                <button type="submit" class="btn btn-primary"><?php echo e(translate('configure')); ?></button>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        function ValidateEmail(inputText) {
            var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
            if (inputText.match(mailformat)) {
                return true;
            } else {
                return false;
            }
        }
        $('.send-mail').on('click', function(){
            send_mail()
        });

        function send_mail() {
            if (ValidateEmail($('#test-email').val())) {
                Swal.fire({
                    title: '<?php echo e(translate('Are you sure?')); ?>?',
                    text: "<?php echo e(translate('a_test_mail_will_be_sent_to_your_email')); ?>!",
                    showCancelButton: true,
                    confirmButtonColor: '#F56A57',
                    cancelButtonColor: 'secondary',
                    confirmButtonText: '<?php echo e(translate('Yes')); ?>!',
                    cancelButtonText: '<?php echo e(translate('Cancel')); ?>!',
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "<?php echo e(route('admin.business-settings.web-app.mail-send')); ?>",
                            method: 'POST',
                            data: {
                                "email": $('#test-email').val()
                            },
                            beforeSend: function () {
                                $('#loading').show();
                            },
                            success: function (data) {
                                if (data.success === 2) {
                                    toastr.error('<?php echo e(translate('email_configuration_error')); ?> !!');
                                } else if (data.success === 1) {
                                    toastr.success('<?php echo e(translate('email_configured_perfectly!')); ?>!');
                                } else {
                                    toastr.info('<?php echo e(translate('email_status_is_not_active')); ?>!');
                                }
                            },
                            complete: function () {
                                $('#loading').hide();

                            }
                        });
                    }
                })
            } else {
                toastr.error('<?php echo e(translate('invalid_email_address')); ?> !!');
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/mail-index.blade.php ENDPATH**/ ?>