<?php $__env->startSection('title', translate('Order Details')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
            <h2 class="h1 mb-0 d-flex align-items-center gap-1">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/order_details.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Order_Details')); ?>

                </span>
            </h2>
            <span class="badge badge-soft-dark rounded-50 fz-14"><?php echo e($order->details->count()); ?></span>
        </div>
        <div class="row" id="printableArea">
            <div class="col-lg-8 mb-3 mb-lg-0">
                <div class="card mb-3 mb-lg-5">
                    <div class="px-card py-3">
                        <div class="row gy-2">
                            <div class="col-sm-6 d-flex flex-column justify-content-between">
                                <div>
                                    <h2 class="page-header-title h1 mb-3"><?php echo e(translate('order')); ?> #<?php echo e($order['id']); ?></h2>
                                     <h2 class="page-header-title h1 mb-3">Order Code #<?php echo e($order['order_code']); ?></h2>
                                    <h5 class="text-capitalize">
                                        <i class="tio-shop"></i>
                                        <?php echo e(translate('branch')); ?> :
                                        <label class="badge-soft-info px-2 rounded">
                                            <?php echo e($order->branch?$order->branch->name:'Branch deleted!'); ?>

                                        </label>
                                    </h5>

                                    <div class="mt-2 d-flex flex-column">
                                        <?php if($order['order_type'] == 'dine_in'): ?>
                                            <div class="hs-unfold">
                                                <h5 class="text-capitalize">
                                                    <i class="tio-table"></i>
                                                    <?php echo e(translate('table no')); ?> : <label
                                                        class="badge badge-secondary"><?php echo e($order->table?$order->table->number:'Table deleted!'); ?></label>
                                                </h5>
                                            </div>
                                            <?php if($order['number_of_people'] != null): ?>
                                                <div class="hs-unfold">
                                                    <h5 class="text-capitalize">
                                                        <i class="tio-user"></i>
                                                        <?php echo e(translate('number of people')); ?> : <label
                                                            class="badge badge-secondary"><?php echo e($order->number_of_people); ?></label>
                                                    </h5>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="">
                                        <?php echo e(translate('Order_Date_&_Time')); ?>: <i class="tio-date-range"></i><?php echo e(date('d M Y',strtotime($order['created_at']))); ?> <?php echo e(date(config('time_format'), strtotime($order['created_at']))); ?>

                                    </div>
                                </div>

                                <div>
                                    <h5><?php echo e(translate('Cutlery Option')); ?> : <span class="<?php echo e($order['is_cutlery_required'] == 1 ? 'badge-soft-success' : 'badge-soft-danger'); ?>"><?php echo e($order['is_cutlery_required'] == 1 ? 'On' : 'Off'); ?></span></h5>
                                    <h5><?php echo e(translate('order')); ?> <?php echo e(translate('note')); ?> : <?php echo e($order['order_note']); ?></h5>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="text-sm-right">
                                    <div class="d-flex flex-wrap gap-2 justify-content-sm-end">
                                        <?php if($order['order_type']!='take_away' && $order['order_type'] != 'pos' && $order['order_type'] != 'dine_in'): ?>

                                            <?php ($googleMapStatus = \App\CentralLogics\Helpers::get_business_settings('google_map_status')); ?>
                                            <?php if($googleMapStatus): ?>
                                                <div class="hs-unfold ml-1">
                                                    <?php if($order['order_status']=='out_for_delivery'): ?>
                                                        <?php ($origin=\App\Model\DeliveryHistory::where(['deliveryman_id'=>$order['delivery_man_id'],'order_id'=>$order['id']])->first()); ?>
                                                        <?php ($current=\App\Model\DeliveryHistory::where(['deliveryman_id'=>$order['delivery_man_id'],'order_id'=>$order['id']])->latest()->first()); ?>
                                                        <?php if(isset($origin)): ?>
                                                            <a class="btn btn-outline-primary" target="_blank"
                                                               title="<?php echo e(translate('Delivery Man Last Location')); ?>" data-toggle="tooltip" data-placement="top"
                                                               href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($origin['latitude']); ?>,<?php echo e($origin['longitude']); ?>&destination=<?php echo e($current['latitude']); ?>,<?php echo e($current['longitude']); ?>">
                                                                <i class="tio-map"></i> <?php echo e(translate('Show_Location_in_Map')); ?>

                                                            </a>
                                                        <?php else: ?>
                                                            <a class="btn btn-outline-primary" href="javascript:" data-toggle="tooltip"
                                                               data-placement="top" title="<?php echo e(translate('Waiting for location...')); ?>">
                                                                <i class="tio-map"></i> <?php echo e(translate('Show_Location_in_Map')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <a class="btn btn-outline-dark last-location-view" href="javascript:"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translate('Only available when order is out for delivery!')); ?>">
                                                            <i class="tio-map"></i> <?php echo e(translate('Show_Location_in_Map')); ?>

                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>

                                        <?php endif; ?>
                                        <a class="btn btn-info" href=<?php echo e(route('admin.orders.generate-invoice',[$order['id']])); ?>>
                                            <i class="tio-print"></i> <?php echo e(translate('Print_Invoice')); ?>

                                        </a>
                                    </div>

                                    <div class="d-flex gap-3 justify-content-sm-end my-3">
                                        <div class="text-dark font-weight-semibold"><?php echo e(translate('Status')); ?> :</div>
                                        <?php if($order['order_status']=='pending'): ?>
                                            <span class="badge-soft-info px-2 rounded text-capitalize"><?php echo e(translate('pending')); ?></span>
                                        <?php elseif($order['order_status']=='confirmed'): ?>
                                            <span class="badge-soft-info px-2 rounded text-capitalize"><?php echo e(translate('confirmed')); ?></span>
                                        <?php elseif($order['order_status']=='processing'): ?>
                                            <span class="badge-soft-warning px-2 rounded text-capitalize"><?php echo e(translate('processing')); ?></span>
                                        <?php elseif($order['order_status']=='out_for_delivery'): ?>
                                            <span class="badge-soft-warning px-2 rounded text-capitalize"><?php echo e(translate('out_for_delivery')); ?></span>
                                        <?php elseif($order['order_status']=='delivered'): ?>
                                            <span class="badge-soft-success px-2 rounded text-capitalize"><?php echo e(translate('delivered')); ?></span>
                                        <?php elseif($order['order_status']=='failed'): ?>
                                            <span class="badge-soft-danger px-2 rounded text-capitalize"><?php echo e(translate('failed_to_deliver')); ?></span>
                                        <?php else: ?>
                                            <span class="badge-soft-danger px-2 rounded text-capitalize"><?php echo e(str_replace('_',' ',$order['order_status'])); ?></span>
                                        <?php endif; ?>
                                    </div>


                                    <div class="text-capitalize d-flex gap-3 justify-content-sm-end mb-3">
                                        <span><?php echo e(translate('payment')); ?> <?php echo e(translate('method')); ?> :</span>
                                        <span class="text-dark"><?php echo e(str_replace('_',' ',$order['payment_method'])); ?></span>
                                    </div>

                                    <?php if(!in_array($order['payment_method'], ['cash_on_delivery', 'wallet_payment', 'offline_payment'])): ?>
                                        <?php if($order['transaction_reference']==null && $order['order_type']!='pos' && $order['order_type'] != 'dine_in'): ?>
                                            <div class="d-flex gap-3 justify-content-sm-end align-items-center mb-3">
                                                <?php echo e(translate('reference')); ?> <?php echo e(translate('code')); ?> :
                                                <button class="btn btn-outline-primary px-3 py-1" data-toggle="modal"
                                                        data-target=".bd-example-modal-sm">
                                                    <?php echo e(translate('add')); ?>

                                                </button>
                                            </div>
                                        <?php elseif($order['order_type']!='pos' && $order['order_type'] != 'dine_in'): ?>
                                            <div class="d-flex gap-3 justify-content-sm-end align-items-center mb-3">
                                                <?php echo e(translate('reference')); ?> <?php echo e(translate('code')); ?>

                                                : <?php echo e($order['transaction_reference']); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>


                                    <div class="d-flex gap-3 justify-content-sm-end mb-3">
                                        <div><?php echo e(translate('Payment_Status')); ?> :</div>
                                        <?php if($order['payment_status']=='paid'): ?>
                                            <span class="badge-soft-success px-2 rounded text-capitalize"><?php echo e(translate('paid')); ?></span>
                                        <?php elseif($order['payment_status']=='partial_paid'): ?>
                                            <span class="badge-soft-success px-2 rounded text-capitalize"><?php echo e(translate('partial_paid')); ?></span>
                                        <?php else: ?>
                                            <span class="badge-soft-danger px-2 rounded text-capitalize"><?php echo e(translate('unpaid')); ?></span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="d-flex gap-3 justify-content-sm-end mb-3 text-capitalize">
                                        <?php echo e(translate('order')); ?> <?php echo e(translate('type')); ?>

                                        : <label class="badge-soft-info px-2 rounded">
                                            <?php echo e(str_replace('_',' ',$order['order_type'])); ?>

                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="py-4 table-responsive">
                        <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light">
                            <tr>
                                <th><?php echo e(translate('SL')); ?></th>
                                <th><?php echo e(translate('Item Details')); ?></th>
                                <th><?php echo e(translate('Price')); ?></th>
                                <th><?php echo e(translate('Discount')); ?></th>
                                <th><?php echo e(translate('Tax')); ?></th>
                                <th class="text-right"><?php echo e(translate('Total_price')); ?></th>
                            </tr>
                            </thead>

                            <tbody>
                            <tr>
                            </tr>
                            <?php ($subTotal=0); ?>
                            <?php ($totalTax=0); ?>
                            <?php ($totalDisOnPro=0); ?>
                            <?php ($addOnsCost=0); ?>
                            <?php ($addOnTax=0); ?>
                            <?php ($addOnsTaxCost=0); ?>
                            <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php ($productDetails = json_decode($detail['product_details'], true)); ?>
                                <?php ($addOnQtys=json_decode($detail['add_on_qtys'],true)); ?>
                                <?php ($addOnPrices=json_decode($detail['add_on_prices'],true)); ?>
                                <?php ($addOnTaxes=json_decode($detail['add_on_taxes'],true)); ?>

                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <div class="media gap-3 w-max-content">

                                            <img class="img-fluid avatar avatar-lg"
                                                 src="<?php echo e($detail->product?->imageFullPath ?? asset('public/assets/admin/img/160x160/img2.jpg')); ?>"
                                                 alt="Image Description">

                                            <div class="media-body text-dark fz-12">
                                                <h6 class="text-capitalize"><?php echo e($productDetails['name']); ?></h6>
                                                <div class="d-flex gap-2">
                                                    <?php if(isset($detail['variation'])): ?>
                                                        <?php $__currentLoopData = json_decode($detail['variation'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(isset($variation['name'])  && isset($variation['values'])): ?>
                                                                <span class="d-block text-capitalize">
                                                                <strong><?php echo e($variation['name']); ?> -</strong>
                                                            </span>
                                                                <?php $__currentLoopData = $variation['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                    <span class="d-block text-capitalize">
                                                                     <?php echo e($value['label']); ?> :
                                                                    <strong><?php echo e(Helpers::set_symbol( $value['optionPrice'])); ?></strong>
                                                                </span>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <?php if(isset(json_decode($detail['variation'],true)[0])): ?>
                                                                    <strong><u> <?php echo e(translate('Variation')); ?> : </u></strong>
                                                                    <?php $__currentLoopData = json_decode($detail['variation'],true)[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class="font-size-sm text-body">
                                                                            <span><?php echo e($key1); ?> :  </span>
                                                                            <span class="font-weight-bold"><?php echo e($variation); ?></span>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        <div class="font-size-sm text-body">
                                                            <span class="text-dark"><?php echo e(translate('price')); ?>  : <?php echo e(Helpers::set_symbol($detail['price'])); ?></span>
                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="d-flex gap-2">
                                                        <span class=""><?php echo e(translate('Qty')); ?> :  </span>
                                                        <span><?php echo e($detail['quantity']); ?></span>
                                                    </div>

                                                    <br>
                                                    <?php ($addon_ids = json_decode($detail['add_on_ids'],true)); ?>
                                                    <?php if($addon_ids): ?>
                                                    <span>
                                                        <u><strong><?php echo e(translate('addons')); ?></strong></u>
                                                        <?php $__currentLoopData = $addon_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 =>$id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php ($addon=\App\Model\AddOn::find($id)); ?>
                                                            <?php ($addOnQtys==null? $add_on_qty=1 : $add_on_qty=$addOnQtys[$key2]); ?>

                                                            <div class="font-size-sm text-body">
                                                                    <span><?php echo e($addon ? $addon['name'] : translate('addon deleted')); ?> :  </span>
                                                                    <span class="font-weight-semibold">
                                                                        <?php echo e($add_on_qty); ?> x <?php echo e(Helpers::set_symbol($addOnPrices[$key2])); ?> <br>
                                                                    </span>
                                                                </div>
                                                            <?php ($addOnsCost+=$addOnPrices[$key2] * $add_on_qty); ?>
                                                            <?php ($addOnsTaxCost +=  $addOnTaxes[$key2] * $add_on_qty); ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php ($amount=$detail['price']*$detail['quantity']); ?>
                                        <?php echo e(Helpers::set_symbol($amount)); ?>

                                    </td>
                                    <td>
                                        <?php ($totDiscount = $detail['discount_on_product']*$detail['quantity']); ?>
                                        <?php echo e(Helpers::set_symbol($totDiscount)); ?>

                                    </td>
                                    <td>
                                        <?php ($productTax = $detail['tax_amount']*$detail['quantity']); ?>
                                        <?php echo e(Helpers::set_symbol($productTax + $addOnsTaxCost)); ?>

                                    </td>
                                    <td class="text-right"><?php echo e(Helpers::set_symbol($amount-$totDiscount + $productTax)); ?></td>
                                </tr>
                                <?php ($totalDisOnPro += $totDiscount); ?>
                                <?php ($subTotal += $amount); ?>
                                <?php ($totalTax += $productTax); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                    <div class="card-body pt-0">
                        <hr>
                        <div class="row justify-content-md-end mb-3">
                            <div class="col-md-9 col-lg-8">
                                <dl class="row">
                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <?php echo e(translate('items')); ?> <?php echo e(translate('price')); ?> <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right"><?php echo e(Helpers::set_symbol($subTotal)); ?></dd>

                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('tax')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right"><?php echo e(Helpers::set_symbol($totalTax + $addOnsTaxCost)); ?></dd>

                                    <dt class="col-6">

                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('addon')); ?> <?php echo e(translate('cost')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        <?php echo e(Helpers::set_symbol($addOnsCost)); ?>

                                    </dd>

                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('item')); ?> <?php echo e(translate('discount')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right"><?php echo e(Helpers::set_symbol($totalDisOnPro)); ?></dd>

                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span>
                                        <?php echo e(translate('subtotal')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        <?php echo e(Helpers::set_symbol($subTotal =$subTotal+$totalTax+$addOnsCost-$totalDisOnPro + $addOnsTaxCost)); ?></dd>

                                    <dt class="col-6">

                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('coupon')); ?> <?php echo e(translate('discount')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        - <?php echo e(Helpers::set_symbol($order['coupon_discount_amount'])); ?></dd>

                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('extra discount')); ?> </span>
                                        <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        - <?php echo e(Helpers::set_symbol($order['extra_discount'])); ?></dd>
                                    <dt class="col-6">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span>
                                                <?php echo e(translate('delivery')); ?> <?php echo e(translate('fee')); ?></span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        <?php if($order['order_type']=='take_away'): ?>
                                            <?php ($del_c=0); ?>
                                        <?php else: ?>
                                            <?php ($del_c=$order['delivery_charge']); ?>
                                        <?php endif; ?>
                                        <?php echo e(Helpers::set_symbol($del_c)); ?>

                                    </dd>

                                    <dt class="col-6 border-top pt-2 fz-16 font-weight-bold">
                                        <div class="d-flex max-w220 ml-auto">
                                            <span><?php echo e(translate('total')); ?></span>
                                        <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 border-top pt-2 fz-16 font-weight-bold text-dark text-right"><?php echo e(Helpers::set_symbol($subTotal - $order['coupon_discount_amount'] - $order['extra_discount'] + $del_c)); ?></dd>

                                    <?php if($order->order_partial_payments->isNotEmpty()): ?>
                                        <?php $__currentLoopData = $order->order_partial_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <dt class="col-6">
                                                <div class="d-flex max-w220 ml-auto">
                                            <span>
                                                <?php echo e(translate('Paid By')); ?> (<?php echo e(str_replace('_', ' ',$partial->paid_with)); ?>)</span>
                                                    <span>:</span>
                                                </div>
                                            </dt>
                                            <dd class="col-6 text-dark text-right">
                                                <?php echo e(Helpers::set_symbol($partial->paid_amount)); ?>

                                            </dd>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $due_amount = 0;
                                                $due_amount = $order->order_partial_payments->first()?->due_amount;
                                            ?>
                                            <dt class="col-6">
                                                <div class="d-flex max-w220 ml-auto">
                                            <span>
                                                <?php echo e(translate('Due Amount')); ?></span>
                                                    <span>:</span>
                                                </div>
                                            </dt>
                                            <dd class="col-6 text-dark text-right">
                                                <?php echo e(Helpers::set_symbol($due_amount)); ?>

                                            </dd>
                                    <?php endif; ?>
                                </dl>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

                <div class="col-lg-4">
                    <?php if($order['order_type'] != 'pos'): ?>
                    <div class="card mb-3">
                        <div class="card-body text-capitalize d-flex flex-column gap-4">
                            <h4 class="mb-0 text-center"><?php echo e(translate('Order_Setup')); ?></h4>

                            <?php if(isset($order->offline_payment)): ?>
                                <div class="card mt-3">
                                    <div class="card-body text-center">
                                        <?php if($order->offline_payment?->status == 1): ?>
                                            <h4 class=""><?php echo e(translate('Payment_verified')); ?></h4>
                                        <?php else: ?>
                                            <h4 class=""><?php echo e(translate('Payment_verification')); ?></h4>
                                            <p class="text-danger"><?php echo e(translate('please verify the payment before confirm order')); ?></p>
                                            <div class="mt-3">
                                                <button class="btn btn-primary" type="button"
                                                        data-id="<?php echo e($order['id']); ?>"
                                                        data-target="#payment_verify_modal" data-toggle="modal"><?php echo e(translate('Verify_Payment')); ?>

                                                </button>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($order['order_type'] != 'pos'): ?>
                                <div class="hs-unfold w-100">
                                    <label class="font-weight-bold text-dark fz-14"><?php echo e(translate('Change_Order_Status')); ?></label>
                                    <div class="dropdown">
                                        <button class="form-control h--45px dropdown-toggle d-flex justify-content-between align-items-center w-100" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                            <?php echo e(translate($order['order_status'])); ?>

                                        </button>
                                        <div class="dropdown-menu text-capitalize" aria-labelledby="dropdownMenuButton">
                                            <?php if($order['payment_method'] == 'offline_payment' && $order->offline_payment?->status != 1): ?>
                                                <?php if($order['order_type'] != 'dine_in'): ?>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('pending')); ?></a>
                                                <?php endif; ?>

                                                <a class="dropdown-item offline-payment-order-alert"
                                                   href="javascript:"><?php echo e(translate('confirmed')); ?></a>

                                                <?php if($order['order_type'] != 'dine_in'): ?>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('processing')); ?></a>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('out_for_delivery')); ?></a>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('delivered')); ?></a>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'returned'])); ?>" data-message="<?php echo e(translate("Change status to returned ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('returned')); ?></a>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'failed'])); ?>" data-message="<?php echo e(translate("Change status to failed ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('failed')); ?></a>
                                                <?php endif; ?>

                                                <?php if($order['order_type'] == 'dine_in'): ?>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('cooking')); ?></a>
                                                    <a class="dropdown-item offline-payment-order-alert"
                                                       href="javascript:"><?php echo e(translate('completed')); ?></a>
                                                <?php endif; ?>
                                                <a class="dropdown-item route-alert"
                                                   data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'canceled'])); ?>" data-message="<?php echo e(translate("Change status to canceled ?")); ?>"
                                                   href="javascript:"><?php echo e(translate('canceled')); ?></a>
                                            <?php else: ?>

                                                <?php if($order['order_type'] != 'dine_in'): ?>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'pending'])); ?>" data-message="<?php echo e(translate("Change status to pending ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('pending')); ?></a>
                                                <?php endif; ?>

                                                <a class="dropdown-item route-alert"
                                                   data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'confirmed'])); ?>" data-message="<?php echo e(translate("Change status to confirmed ?")); ?>"
                                                   href="javascript:"><?php echo e(translate('confirmed')); ?></a>

                                                <?php if($order['order_type'] != 'dine_in'): ?>
                                                    <a class="dropdown-item route-alert"
                                                        data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'processing'])); ?>" data-message="<?php echo e(translate("Change status to processing ?")); ?>"
                                                        href="javascript:"><?php echo e(translate('processing')); ?></a>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'out_for_delivery'])); ?>" data-message="<?php echo e(translate("Change status to out for delivery ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('out_for_delivery')); ?></a>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'delivered'])); ?>" data-message="<?php echo e(translate("Change status to delivered ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('delivered')); ?></a>

                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'returned'])); ?>" data-message="<?php echo e(translate("Change status to returned ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('returned')); ?></a>

                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'failed'])); ?>" data-message="<?php echo e(translate("Change status to failed ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('failed')); ?></a>
                                                <?php endif; ?>
                                                <?php if($order['order_type'] == 'dine_in'): ?>
                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'cooking'])); ?>" data-message="<?php echo e(translate("Change status to cooking ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('cooking')); ?></a>

                                                    <a class="dropdown-item route-alert"
                                                       data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'completed'])); ?>" data-message="<?php echo e(translate("Change status to completed ?")); ?>"
                                                       href="javascript:"><?php echo e(translate('completed')); ?></a>
                                                <?php endif; ?>

                                                <a class="dropdown-item route-alert"
                                                   data-route="<?php echo e(route('admin.orders.status',['id'=>$order['id'],'order_status'=>'canceled'])); ?>" data-message="<?php echo e(translate("Change status to canceled ?")); ?>"
                                                   href="javascript:"><?php echo e(translate('canceled')); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <div class="d-flex justify-content-between align-items-center gap-10 form-control">
                                        <span class="title-color"><?php echo e(translate('Payment Status')); ?></span>
                                        <?php if($order['payment_method'] == 'offline_payment' && $order->offline_payment?->status != 1): ?>
                                            <label class="switcher payment-status-text">
                                                <input class="switcher_input offline-payment-status-alert" type="checkbox" name="payment_status" value="1" id="payment_status_switch"
                                                    <?php echo e($order->payment_status == 'paid' ?'checked':''); ?>>
                                                <span class="switcher_control"></span>
                                            </label>
                                        <?php else: ?>
                                            <label class="switcher payment-status-text">
                                                <input class="switcher_input change-payment-status" type="checkbox" name="payment_status" value="1"
                                                       data-id="<?php echo e($order['id']); ?>"
                                                       data-status="<?php echo e($order->payment_status == 'paid' ?'unpaid':'paid'); ?>"
                                                    <?php echo e($order->payment_status == 'paid' ?'checked':''); ?>>
                                                <span class="switcher_control"></span>
                                            </label>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($order->customer || $order->is_guest == 1): ?>
                                <div>
                                    <label class="font-weight-bold text-dark fz-14"><?php echo e(translate('Delivery_Date_&_Time')); ?> <?php echo e($order['delivery_date'] > \Carbon\Carbon::now()->format('Y-m-d')? translate('(Scheduled)') : ''); ?></label>
                                    <div class="d-flex gap-2 flex-wrap flex-xxl-nowrap">
                                        <input name="delivery_date" type="date" class="form-control delivery-date" value="<?php echo e($order['delivery_date'] ?? ''); ?>">
                                        <input name="delivery_time" type="time" class="form-control delivery-time" value="<?php echo e($order['delivery_time'] ?? ''); ?>">
                                    </div>

                                </div>
                                <?php if($order['order_type']!='take_away' && $order['order_type'] != 'pos' && $order['order_type'] != 'dine_in' && !$order['delivery_man_id']): ?>

                                    <a href="#" class="btn btn-primary btn-block d-flex gap-1 justify-content-center align-items-center" data-toggle="modal" data-target="#assignDeliveryMan">
                                        <img width="17" src="<?php echo e(asset('public/assets/admin/img/icons/assain_delivery_man.png')); ?>" alt="">
                                        <?php echo e(translate('Assign_Delivery_Man')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div>
                                <?php if($order['order_type'] != 'pos' && $order['order_type'] != 'take_away' && ($order['order_status'] != DELIVERED && $order['order_status'] != RETURNED && $order['order_status'] != CANCELED && $order['order_status'] != FAILED && $order['order_status'] != COMPLETED)): ?>
                                    <label class="font-weight-bold text-dark fz-14"><?php echo e(translate('Food_Preparation_Time')); ?></label>
                                    <div class="form-control justify-content-between">
                                        <span class="ml-2 ml-sm-3 ">
                                        <i class="tio-timer d-none" id="timer-icon"></i>
                                        <span id="counter" class="text-info"></span>
                                        <i class="tio-edit p-2 d-none li-pointer" id="edit-icon" data-toggle="modal" data-target="#counter-change" data-whatever="@mdo"></i>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>


                            <?php if($order->delivery_man_id): ?>
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h4 class="mb-4 d-flex gap-2">
                                    <span class="card-header-icon">
                                        <i class="tio-user text-dark"></i>
                                    </span>
                                            <span><?php echo e(translate('delivery_man')); ?></span>
                                            <a  href="#"  data-toggle="modal" data-target="#assignDeliveryMan"
                                                class="text--base cursor-pointer ml-auto">
                                                <?php echo e(translate('Change')); ?>

                                            </a>
                                        </h4>
                                        <div class="media flex-wrap gap-3">
                                            <a>
                                                <img class="avatar avatar-lg rounded-circle" src="<?php echo e($order->delivery_man?->imageFullPath); ?>" alt="Image">
                                            </a>
                                            <div class="media-body d-flex flex-column gap-1">
                                                <a target="" href="#" class="text-dark"><span><?php echo e($order->delivery_man['f_name'].' '.$order->delivery_man['l_name'] ?? ''); ?></span></a>
                                                <span class="text-dark"> <span><?php echo e($order->delivery_man['orders_count']); ?></span> <?php echo e(translate('Orders')); ?></span>
                                                <span class="text-dark break-all">
                                            <i class="tio-call-talking-quiet mr-2"></i>
                                            <a href="tel:<?php echo e($order->delivery_man['phone']); ?>" class="text-dark"><?php echo e($order->delivery_man['phone'] ?? ''); ?></a>
                                        </span>
                                                <span class="text-dark break-all">
                                            <i class="tio-email mr-2"></i>
                                            <a href="mailto:<?php echo e($order->delivery_man['email']); ?>" class="text-dark"><?php echo e($order->delivery_man['email'] ?? ''); ?></a>
                                        </span>
                                            </div>
                                        </div>
                                        <hr class="w-100">
                                        <?php if($order['order_status']=='out_for_delivery'): ?>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5><?php echo e(translate('Last_location')); ?></h5>
                                            </div>
                                            <?php ($origin=\App\Model\DeliveryHistory::where(['deliveryman_id'=>$order['delivery_man_id'],'order_id'=>$order['id']])->first()); ?>
                                            <?php ($current=\App\Model\DeliveryHistory::where(['deliveryman_id'=>$order['delivery_man_id'],'order_id'=>$order['id']])->latest()->first()); ?>
                                            <?php if(isset($origin)): ?>
                                                <a target="_blank" class="text-dark"
                                                   title="Delivery Boy Last Location" data-toggle="tooltip" data-placement="top"
                                                   href="http://maps.google.com/maps?z=12&t=m&q=loc:<?php echo e($current['latitude']); ?>+<?php echo e($current['longitude']); ?>">
                                                    <img width="13" src="<?php echo e(asset('public/assets/admin/img/icons/location.png')); ?>" alt="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e($current['location']?? ''); ?>

                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:" data-toggle="tooltip" class="text-dark"
                                                   data-placement="top" title="<?php echo e(translate('Waiting for location...')); ?>">
                                                    <img width="13" src="<?php echo e(asset('public/assets/admin/img/icons/location.png')); ?>" alt="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e(translate('Waiting for location...')); ?>

                                                </a>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <a href="javascript:" class="text-dark last-location-view"
                                               data-toggle="tooltip" data-placement="top"
                                               title="<?php echo e(translate('Only available when order is out for delivery!')); ?>">
                                                <img width="13" src="<?php echo e(asset('public/assets/admin/img/icons/location.png')); ?>" alt="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e(translate('Only available when order is out for delivery!')); ?>

                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($order['order_type']!='take_away' && $order['order_type'] != 'pos' && $order['order_type'] != 'dine_in'): ?>
                            <div class="card">
                                <div class="card-body">
                                    <div class="mb-4 d-flex gap-2 justify-content-between">
                                        <h4 class="mb-0 d-flex gap-2">
                                            <i class="tio-user text-dark"></i>
                                            <?php echo e(translate('Delivery_Informatrion')); ?>

                                        </h4>

                                        <div class="edit-btn cursor-pointer" data-toggle="modal" data-target="#deliveryInfoModal">
                                            <i class="tio-edit"></i>
                                        </div>
                                    </div>
                                    <div class="delivery--information-single flex-column">
                                        <?php ($address=\App\Model\CustomerAddress::find($order['delivery_address_id'])); ?>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('Name')); ?></div>
                                            <div class="info"><?php echo e($address? $address['contact_person_name']: ''); ?></div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('Contact')); ?></div>
                                            <a href="tel:<?php echo e($address? $address['contact_person_number']: ''); ?>" class="info"><?php echo e($address? $address['contact_person_number']: ''); ?></a>
                                        </div>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('floor')); ?></div>
                                            <div class="info"><?php echo e($address['floor'] ?? ''); ?></div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('house')); ?></div>
                                            <div class="info"><?php echo e($address['house'] ?? ''); ?></div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('road')); ?></div>
                                            <div class="info"><?php echo e($address['road'] ?? ''); ?></div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="name"><?php echo e(translate('address')); ?></div>
                                            <div class="info"><?php echo e($address['address'] ?? ''); ?></div>
                                        </div>
                                        <?php if($order->order_area): ?>
                                            <div class="d-flex">
                                                <div class="name"><?php echo e(translate('Area')); ?></div>
                                                <div class="info edit-btn cursor-pointer">
                                                    <?php echo e($order?->order_area?->area?->area_name); ?>

                                                    <?php if($order?->branch?->delivery_charge_setup?->delivery_charge_type == 'area'): ?>
                                                        <i class="tio-edit" data-toggle="modal" data-target="#editArea"></i>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php ($googleMapStatus = \App\CentralLogics\Helpers::get_business_settings('google_map_status')); ?>
                                        <?php if($googleMapStatus): ?>
                                            <?php if(isset($address['address']) && isset($address['latitude']) && isset($address['longitude'])): ?>
                                                <hr class="w-100">
                                                <div class="d-flex align-items-center gap-3">
                                                    <a target="_blank" class="text-dark"
                                                       href="http://maps.google.com/maps?z=12&t=m&q=loc:<?php echo e($address['latitude']); ?>+<?php echo e($address['longitude']); ?>">
                                                        <img width="13" src="<?php echo e(asset('public/assets/admin/img/icons/location.png')); ?>" alt="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                        <?php echo e($address['address']); ?>

                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                        </div>
                    </div>
                    <?php endif; ?>

                        <?php if($order->offline_payment): ?>
                            <?php ($payment = json_decode($order->offline_payment?->payment_info, true)); ?>

                            <div class="card mt-2">
                                <div class="card-body">
                                    <h5 class="form-label mb-3">
                                        <span class="card-header-icon"><i class="tio-shopping-basket"></i></span>
                                        <span><?php echo e(translate('Offline payment information')); ?></span>
                                    </h5>
                                    <div class="offline-payment--information-single flex-column mt-3">
                                        <div class="d-flex">
                                            <span class="name"><?php echo e(translate('payment_note')); ?></span>
                                            <span class="info"><?php echo e($payment['payment_note']); ?></span>
                                        </div>
                                        <?php $__currentLoopData = $payment['method_information']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $infos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info_key => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="d-flex">
                                                    <span class="name"><?php echo e($info_key); ?></span>
                                                    <span class="info"><?php echo e($info); ?></span>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>


                    <div class="card mb-3">
                        <div class="card-body">
                            <h4 class="mb-4 d-flex gap-2">
                                <i class="tio-user text-dark"></i>
                                <?php echo e(translate('Customer Information')); ?>

                            </h4>
                            <?php if($order->is_guest == 1): ?>
                                <div class="media flex-wrap gap-3 align-items-center">
                                    <a target="#" class="" >
                                        <img class="avatar avatar-lg rounded-circle" src="<?php echo e(asset('public/assets/admin/img/160x160/img1.jpg')); ?>" alt="">
                                    </a>
                                    <div class="media-body d-flex flex-column gap-1">
                                        <a target="#"  class="text-dark text-capitalize"><strong><?php echo e(translate('Guest Customer')); ?></strong></a>
                                    </div>
                                </div>
                            <?php else: ?>
                                <?php if($order->customer): ?>
                                    <div class="media flex-wrap gap-3">
                                        <a target="_blank" class="" href="<?php echo e(route('admin.customer.view',[$order->customer['id']])); ?>">
                                            <img class="avatar avatar-lg rounded-circle" src="<?php echo e($order->customer?->imageFullPath); ?>" alt="Image">
                                        </a>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <a target="_blank" href="<?php echo e(route('admin.customer.view',[$order->customer['id']])); ?>" class="text-dark"><strong><?php echo e($order->customer['f_name'].' '.$order->customer['l_name']); ?></strong></a>
                                            <span class="text-dark"><?php echo e($order->customer['orders_count']); ?> <?php echo e(translate('Orders')); ?></span>
                                            <span class="text-dark">
                                            <i class="tio-call-talking-quiet mr-2"></i>
                                            <a class="text-dark break-all" href="tel:<?php echo e($order->customer['phone']); ?>"><?php echo e($order->customer['phone']); ?></a>
                                        </span>
                                            <span class="text-dark">
                                            <i class="tio-email mr-2"></i>
                                            <a class="text-dark break-all" href="mailto:<?php echo e($order->customer['email']); ?>"><?php echo e($order->customer['email']); ?></a>
                                        </span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($order->user_id == null): ?>
                                    <div class="media flex-wrap gap-3 align-items-center">
                                        <a target="#" class="" >
                                            <img class="avatar avatar-lg rounded-circle" src="<?php echo e(asset('public/assets/admin/img/160x160/img1.jpg')); ?>" alt="">
                                        </a>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <a target="#"  class="text-dark text-capitalize"><strong><?php echo e(translate('walking_customer')); ?></strong></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($order->user_id != null && !isset($order->customer)): ?>
                                    <div class="media flex-wrap gap-3 align-items-center">
                                        <a target="#" class="" >
                                            <img class="avatar avatar-lg rounded-circle" src="<?php echo e(asset('public/assets/admin/img/160x160/img1.jpg')); ?>" alt="">
                                        </a>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <a target="#"  class="text-dark text-capitalize"><strong><?php echo e(translate('Customer_not_available')); ?></strong></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                        </div>
                    </div>

                    <div class="card mb-3">
                        <div class="card-body">
                            <h4 class="mb-4 d-flex gap-2">
                                <i class="tio-user text-dark"></i>
                                <?php echo e(translate('Branch Information')); ?>

                            </h4>
                            <div class="media flex-wrap gap-3">
                                <div class="">
                                    <img class="avatar avatar-lg rounded-circle" src="<?php echo e($order->branch?->imageFullPath); ?>" alt="Image">
                                </div>
                                <div class="media-body d-flex flex-column gap-1">
                                    <?php if(isset($order->branch)): ?>
                                        <span class="text-dark"><span><?php echo e($order->branch?->name); ?></span></span>
                                        <span class="text-dark"> <span><?php echo e($order->branch['orders_count']); ?></span> <?php echo e(translate('Orders served')); ?></span>
                                        <?php if($order->branch['phone']): ?>
                                            <span class="text-dark break-all">
                                                <i class="tio-call-talking-quiet mr-2"></i>
                                                <a class="text-dark" href="tel:<?php echo e($order->branch?->phone); ?>"><?php echo e($order->branch?->phone); ?></a>
                                            </span>
                                        <?php endif; ?>
                                        <span class="text-dark break-all">
                                        <i class="tio-email mr-2"></i>
                                        <a class="text-dark" href="mailto:<?php echo e($order->branch?->email); ?>"><?php echo e($order->branch->email); ?></a>
                                    </span>
                                    <?php else: ?>
                                        <span class="fz--14px text--title font-semibold text-hover-primary d-block">
                                            <?php echo e(translate('Branch Deleted')); ?>

                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <?php if(isset($order->branch)): ?>
                                <hr class="w-100">
                                <div class="d-flex align-items-center text-dark gap-3">
                                    <img width="13" src="<?php echo e(asset('public/assets/admin/img/icons/location.png')); ?>" alt="">
                                    <a target="_blank" class="text-dark"
                                       href="http://maps.google.com/maps?z=12&t=m&q=loc:<?php echo e($order->branch['latitude']); ?>+<?php echo e($order->branch['longitude']); ?>">
                                        <?php echo e($order->branch['address']); ?><br>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
        </div>
    </div>

    <div class="modal fade" id="assignDeliveryMan" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title fs-5" id="assignDeliveryManLabel"><?php echo e(translate('Assign_Delivery_Man')); ?></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group">
                        <?php $__currentLoopData = $deliverymen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryMan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex flex-wrap align-items-center gap-3 justify-content-between">
                                <div class="media align-items-center gap-2 flex-wrap">
                                    <div class="avatar">
                                        <img class="img-fit rounded-circle" loading="lazy" decoding="async"
                                         src="<?php echo e($deliveryMan->imageFullPath); ?>" alt="Jhon Doe">
                                    </div>
                                    <span><?php echo e($deliveryMan['f_name'].' '.$deliveryMan['l_name']); ?></span>
                                </div>
                                <a id="<?php echo e($deliveryMan->id); ?>" class="btn btn-primary btn-sm assign-deliveryman"><?php echo e(translate('Assign')); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bd-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title h4"
                        id="mySmallModalLabel"><?php echo e(translate('reference')); ?> <?php echo e(translate('code')); ?> <?php echo e(translate('add')); ?></h5>
                    <button type="button" class="btn btn-xs btn-icon btn-ghost-secondary" data-dismiss="modal"
                            aria-label="Close">
                        <i class="tio-clear tio-lg"></i>
                    </button>
                </div>

                <form action="<?php echo e(route('admin.orders.add-payment-ref-code',[$order['id']])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="text" name="transaction_reference" class="form-control"
                                   placeholder="<?php echo e(translate('EX : Code123')); ?>" required>
                        </div>
                        <button class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deliveryInfoModal" id="deliveryInfoModal"
         aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title h4" id="mySmallModalLabel"><?php echo e(translate('Update_Delivery_Information')); ?></h5>
                    <button type="button" class="btn btn-xs btn-icon btn-ghost-secondary" data-dismiss="modal" aria-label="Close">
                        <i class="tio-clear tio-lg"></i>
                    </button>
                </div>
                <?php if($order['delivery_address_id']): ?>
                    <form action="<?php echo e(route('admin.orders.update-shipping',[$order['delivery_address_id']])); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id" value="<?php echo e($order->user_id); ?>">
                        <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(translate('Type')); ?></label>
                                        <input type="text" name="address_type" class="form-control"
                                               placeholder="<?php echo e(translate('EX : Home')); ?>" value="<?php echo e($address['address_type'] ?? ''); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="input-label" for=""><?php echo e(translate('contact_person_name')); ?>

                                            <span class="input-label-secondary text-danger">*</span></label>
                                        <input type="text" class="form-control" name="contact_person_name"
                                               placeholder="<?php echo e(translate('EX : Jhon Doe')); ?>" value="<?php echo e($address['contact_person_name'] ?? ''); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="input-label" for=""><?php echo e(translate('Contact Number')); ?>

                                            <span class="input-label-secondary text-danger">*</span></label>
                                        <input type="text" class="form-control" name="contact_person_number"
                                               placeholder="<?php echo e(translate('EX : 01888888888')); ?>" value="<?php echo e($address['contact_person_number']?? ''); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(translate('floor')); ?></label>
                                        <input type="text" class="form-control" name="floor"
                                               placeholder="<?php echo e(translate('EX : 5')); ?>" value="<?php echo e($address['floor'] ?? ''); ?>" >
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(translate('house')); ?></label>
                                        <input type="text" class="form-control" name="house"
                                               placeholder="<?php echo e(translate('EX : 21/B')); ?>" value="<?php echo e($address['house'] ?? ''); ?>" >
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(translate('road')); ?></label>
                                        <input type="text" class="form-control" name="road"
                                               placeholder="<?php echo e(translate('EX : Baker Street')); ?>" value="<?php echo e($address['road'] ?? ''); ?>" >
                                    </div>
                                </div>

                                <?php ($googleMapStatus = \App\CentralLogics\Helpers::get_business_settings('google_map_status')); ?>
                                <?php if($googleMapStatus): ?>
                                    <?php if($order?->branch?->delivery_charge_setup?->delivery_charge_type == 'distance'): ?>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="input-label" for=""><?php echo e(translate('latitude')); ?>

                                                    <span class="input-label-secondary text-danger">*</span></label>
                                                <input type="text" class="form-control" name="latitude"
                                                       placeholder="<?php echo e(translate('EX : 23.796584198263794')); ?>" value="<?php echo e($address['latitude'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="input-label" for=""><?php echo e(translate('longitude')); ?><span
                                                        class="input-label-secondary text-danger">*</span></label>
                                                <input type="text" class="form-control" name="longitude"
                                                       placeholder="<?php echo e(translate('EX : 23.796584198263794')); ?>" value="<?php echo e($address['longitude'] ?? ''); ?>" required>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(translate('Address')); ?><span class="input-label-secondary text-danger">*</span></label>
                                        <textarea class="form-control" name="address" cols="30" rows="3" placeholder="<?php echo e(translate('EX : Dhaka,_Bangladesh')); ?>" required><?php echo e($address['address'] ?? ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <button class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </div>
                    </form>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <?php if($order['order_type'] != 'pos' && $order['order_type'] != 'take_away' && ($order['order_status'] != DELIVERED && $order['order_status'] != RETURNED && $order['order_status'] != CANCELED && $order['order_status'] != FAILED && $order['order_status'] != COMPLETED)): ?>
        <div class="modal fade" id="counter-change" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title custom-text-size" id="exampleModalLabel"><?php echo e(translate('Need time to prepare the food')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('admin.orders.increase-preparation-time', ['id' => $order->id])); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group text-center">
                                <input type="number" min="0" name="extra_minute" id="extra_minute" class="form-control" placeholder="<?php echo e(translate('EX : 20')); ?>" required>
                            </div>
                            <div class="form-group flex-between predefined-time-input">
                                <div class="badge text-info shadow li-pointer" data-time="10"><?php echo e(translate('10min')); ?></div>
                                <div class="badge text-info shadow li-pointer" data-time="20"><?php echo e(translate('20min')); ?></div>
                                <div class="badge text-info shadow li-pointer" data-time="30"><?php echo e(translate('30min')); ?></div>
                                <div class="badge text-info shadow li-pointer" data-time="40"><?php echo e(translate('40min')); ?></div>
                                <div class="badge text-info shadow li-pointer" data-time="50"><?php echo e(translate('50min')); ?></div>
                                <div class="badge text-info shadow li-pointer" data-time="60"><?php echo e(translate('60min')); ?></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(translate('Close')); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Submit')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($order->offline_payment): ?>
        <div class="modal fade" id="payment_verify_modal">
            <div class="modal-dialog modal-lg offline-details">
                <div class="modal-content">
                    <div class="modal-header justify-content-center">
                        <h4 class="modal-title pb-2"><?php echo e(translate('Payment_Verification')); ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                    <div class="card">
                        <div class="modal-body mx-2">
                            <p class="text-danger"><?php echo e(translate('Please Check & Verify the payment information whether it is correct or not before confirm the order.')); ?></p>
                            <h5><?php echo e(translate('customer_Information')); ?></h5>

                            <div class="card-body">
                                <?php if($order->is_guest == 0): ?>
                                    <p><?php echo e(translate('name')); ?> : <?php echo e($order->customer ? $order->customer->f_name.' '. $order->customer->l_name: ''); ?> </p>
                                    <p><?php echo e(translate('contact')); ?> : <?php echo e($order->customer ? $order->customer->phone: ''); ?></p>
                                <?php else: ?>
                                    <p><?php echo e(translate('guest_customer')); ?> </p>
                                <?php endif; ?>
                            </div>

                            <h5><?php echo e(translate('Payment_Information')); ?></h5>
                            <?php ($payment = json_decode($order->offline_payment?->payment_info, true)); ?>
                            <div class="row card-body">
                                <div class="col-md-6">
                                    <p><?php echo e(translate('Payment_Method')); ?> : <?php echo e($payment['payment_name']); ?></p>
                                    <?php $__currentLoopData = $payment['method_fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field_key => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p><?php echo e($field_key); ?> : <?php echo e($field); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="col-md-6">
                                    <p><?php echo e(translate('payment_note')); ?> : <?php echo e($payment['payment_note']); ?></p>
                                    <?php $__currentLoopData = $payment['method_information']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $infos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info_key => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p><?php echo e($info_key); ?> : <?php echo e($info); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="btn--container justify-content-center my-2 mx-3">
                        <?php if($order->offline_payment?->status == 0): ?>
                            <a type="reset" class="btn btn-secondary verify-offline-payment" data-status="2"><?php echo e(translate('Payment_Did_Not_Received')); ?></a>
                        <?php endif; ?>
                        <a type="submit" class="btn btn-primary verify-offline-payment" data-status="1"><?php echo e(translate('Yes,_Payment_Received')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="editArea" id="editArea"
         aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title h4" id="mySmallModalLabel"><?php echo e(translate('Update_Delivery_Area')); ?></h5>
                    <button type="button" class="btn btn-xs btn-icon btn-ghost-secondary" data-dismiss="modal" aria-label="Close">
                        <i class="tio-clear tio-lg"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.orders.update-order-delivery-area', ['order_id' => $order->id])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">

                            <?php
                            $branch = \App\Model\Branch::with(['delivery_charge_setup', 'delivery_charge_by_area'])
                                ->where(['id' => $order['branch_id']])
                                ->first(['id', 'name', 'status']);
                            ?>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(translate('Delivery Area')); ?></label>
                                    <select name="selected_area_id" class="form-control js-select2-custom-x mx-1" id="areaDropdown" >
                                        <option value=""><?php echo e(translate('Select Area')); ?></option>
                                        <?php $__currentLoopData = $branch->delivery_charge_by_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($area['id']); ?>" <?php echo e((isset($order->order_area) && $order->order_area->area_id == $area['id']) ? 'selected' : ''); ?>

                                            data-charge="<?php echo e($area['delivery_charge']); ?>" ><?php echo e($area['area_name']); ?> - (<?php echo e(Helpers::set_symbol($area['delivery_charge'])); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="input-label" for=""><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                <input type="number" class="form-control" name="delivery_charge" id="deliveryChargeInput" value="" readonly>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button class="btn btn-primary"><?php echo e(translate('update')); ?></button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $('.assign-deliveryman').click(function() {
            var deliveryManId = $(this).attr('id');
            addDeliveryMan(deliveryManId);
        });

        $('.change-payment-status').on('click', function(){
            let id = $(this).data('id');
            let status = $(this).data('status');
            let paymentStatusRoute = "<?php echo e(route('admin.orders.payment-status')); ?>";
            location.href = paymentStatusRoute + '?id=' + encodeURIComponent(id) + '&payment_status=' + encodeURIComponent(status);
        });

        $('.last-location-view').click(function (){
            last_location_view();
        })

        $('.delivery-date, .delivery-time').on('change', function() {
            changeDeliveryTimeDate(this);
        });

        $('.predefined-time-input .badge').click(function() {
            var time = $(this).data('time');
            predefined_time_input(time);
        });

        $('.verify-offline-payment').click(function() {
            var status = $(this).data('status');
            verify_offline_payment(status);
        });

        $('.offline-payment-status-alert').on('click', function () {
            Swal.fire({
                title: '<?php echo e(translate("Payment_is_Not_Verified")); ?>',
                text: '<?php echo e(translate("You can not change status of unverified offline payment")); ?>',
                type: 'question',
                showCancelButton: true,
                showConfirmButton: false,
                cancelButtonColor: 'default',
                confirmButtonColor: '#01684b',
                cancelButtonText: '<?php echo e(translate("Close")); ?>',
                confirmButtonText: '',
                reverseButtons: true
            }).then((result) => {
                $('#payment_status_switch').prop('checked', false);
            })
        })

        $('.offline-payment-order-alert').on('click', function () {
            Swal.fire({
                title: '<?php echo e(translate("Payment_is_Not_Verified")); ?>',
                text: '<?php echo e(translate("You can not change order status to this status. Please Check & Verify the payment information whether it is correct or not. You can only change order status to failed or cancel if payment is not verified.")); ?>',
                type: 'question',
                showCancelButton: true,
                showConfirmButton: false,
                cancelButtonColor: 'default',
                confirmButtonColor: '#01684b',
                cancelButtonText: '<?php echo e(translate("Close")); ?>',
                confirmButtonText: '<?php echo e(translate("Proceed")); ?>',
                reverseButtons: true
            }).then((result) => {

            })
        })

        function addDeliveryMan(id) {
            $.ajax({
                type: "GET",
                url: '<?php echo e(url('/')); ?>/admin/orders/add-delivery-man/<?php echo e($order['id']); ?>/' + id,
                data: $('#product_form').serialize(),
                success: function (data) {
                    if(data.status == true) {
                        toastr.success('<?php echo e(translate("Delivery man successfully assigned/changed")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function () {
                            location.reload();
                        }, 2000)
                    }else{
                        toastr.error('<?php echo e(translate("Deliveryman man can not assign/change in that status")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                },
                error: function () {
                    toastr.error('<?php echo e(translate("Add valid data")); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        }

        function last_location_view() {
            toastr.warning('<?php echo e(translate("Only available when order is out for delivery!")); ?>', {
                CloseButton: true,
                ProgressBar: true
            });
        }

        function predefined_time_input(min) {
            document.getElementById("extra_minute").value = min;
        }

        function changeDeliveryTimeDate(t) {
            let name = t.name
            let value = t.value
            $.ajax({
                type: "GET",
                url: '<?php echo e(url('/')); ?>/admin/orders/ajax-change-delivery-time-date/<?php echo e($order['id']); ?>?' + t.name + '=' + t.value,
                data: {
                    name : name,
                    value : value
                },
                success: function (data) {
                    console.log(data)
                    if(data.status == true && name == 'delivery_date') {
                        toastr.success('<?php echo e(translate("Delivery date changed successfully")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else if(data.status == true && name == 'delivery_time'){
                        toastr.success('<?php echo e(translate("Delivery time changed successfully")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else {
                        toastr.error('<?php echo e(translate("Order No is not valid")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    location.reload();
                },
                error: function () {
                    toastr.error('<?php echo e(translate("Add valid data")); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
            });
        }

        function verify_offline_payment(status) {
            $.ajax({
                type: "GET",
                url: '<?php echo e(url('/')); ?>/admin/orders/verify-offline-payment/<?php echo e($order['id']); ?>/' + status,
                success: function (data) {
                    //console.log(data);
                    location.reload();
                    if(data.status == true) {
                        toastr.success('<?php echo e(translate("offline payment verify status changed")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else{
                        toastr.error('<?php echo e(translate("offline payment verify status not changed")); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }

                },
                error: function () {
                }
            });
        }


    </script>
    <?php if($order['order_type'] != 'pos' && $order['order_type'] != 'take_away' && ($order['order_status'] != DELIVERED && $order['order_status'] != RETURNED && $order['order_status'] != CANCELED && $order['order_status'] != FAILED && $order['order_status'] != COMPLETED)): ?>
        <script>
            "use strict";

            const expire_time = "<?php echo e($order['remaining_time']); ?>";
            var countDownDate = new Date(expire_time).getTime();
            const time_zone = "<?php echo e(Helpers::get_business_settings('time_zone') ?? 'UTC'); ?>";

            var x = setInterval(function() {
                var now = new Date(new Date().toLocaleString("en-US", {timeZone: time_zone})).getTime();

                var distance = countDownDate - now;

                var days = Math.trunc(distance / (1000 * 60 * 60 * 24));
                var hours = Math.trunc((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.trunc((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.trunc((distance % (1000 * 60)) / 1000);


                document.getElementById("timer-icon").classList.remove("d-none");
                document.getElementById("edit-icon").classList.remove("d-none");
                var $text = (distance < 0) ? "<?php echo e(translate('over')); ?>" : "<?php echo e(translate('left')); ?>";
                document.getElementById("counter").innerHTML = Math.abs(days) + "d " + Math.abs(hours) + "h " + Math.abs(minutes) + "m " + Math.abs(seconds) + "s " + $text;
                if (distance < 0) {
                    var element = document.getElementById('counter');
                    element.classList.add('text-danger');
                }
            }, 1000);


            $(document).ready(function() {
                const $areaDropdown = $('#areaDropdown');
                const $deliveryChargeInput = $('#deliveryChargeInput');

                $areaDropdown.change(function() {
                    const selectedOption = $(this).find('option:selected');
                    const charge = selectedOption.data('charge');
                    $deliveryChargeInput.val(charge);
                });
            });


        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/order/order-view.blade.php ENDPATH**/ ?>