<?php $__env->startSection('title', translate('Business Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('business_setup')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._business-setup-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.business-settings.restaurant.order-update')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="mb-0">
                        <?php echo e(translate('Order Settings')); ?>

                    </h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php ($mov=\App\Model\BusinessSetting::where('key','minimum_order_value')->first()->value); ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label">
                                    <?php echo e(translate('min_Order_value')); ?> ( <?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?> )
                                </label>
                                <input type="number" min="1" value="<?php echo e($mov); ?>"
                                       name="minimum_order_value" class="form-control" placeholder="<?php echo e(translate('Ex: 9.43896534')); ?>"
                                       required>
                            </div>
                        </div>












                        <div class="col-md-4 col-sm-6">
                            <?php ($scheduleOrderSlotDuration=\App\CentralLogics\Helpers::get_business_settings('schedule_order_slot_duration')); ?>
                            <div class="form-group">
                                <label class="input-label text-capitalize" for="schedule_order_slot_duration"><?php echo e(translate('Schedule_Order_Slot_Duration_Minute')); ?></label>
                                <input type="number" name="schedule_order_slot_duration" class="form-control" id="schedule_order_slot_duration" value="<?php echo e($scheduleOrderSlotDuration?$scheduleOrderSlotDuration:0); ?>" min="1" placeholder="<?php echo e(translate('Ex: 30')); ?>" required>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6 mb-4 mt-5">
                            <?php ($cutleryStatus=\App\CentralLogics\Helpers::get_business_settings('cutlery_status')); ?>
                            <div class="form-control d-flex justify-content-between align-items-center gap-3">
                                <div>
                                    <label class="text-dark mb-0"><?php echo e(translate('cutlery status')); ?>

                                        <i class="tio-info-outined"
                                           data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?php echo e(translate('When this option is enabled, users can select whether user want cutlery or not.')); ?>">
                                        </i>
                                    </label>
                                </div>
                                <label class="switcher">
                                    <input class="switcher_input" type="checkbox" name="cutlery_status" <?php echo e($cutleryStatus == null || $cutleryStatus == 0? '' : 'checked'); ?> id="cutlery_status">
                                    <span class="switcher_control"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="btn--container">
                        <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                        <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                class="btn btn-primary call-demo"><?php echo e(translate('submit')); ?></button>
                    </div>
                </div>
            </div>

        </form>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/order-index.blade.php ENDPATH**/ ?>