<?php $__env->startSection('title', translate('Deliveryman_Details')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/takeaway.png')); ?>"
                    alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Deliveryman_Details')); ?>

                </span>
            </h2>
        </div>

        <div class="card">
            <div class="card-top border-bottom py-3 p-20">
                <h2 class="page-header-title text-title">
                    <?php echo e(translate('Profile_Details')); ?>

                </h2>
            </div>
            <div class="row p-20">
                <div class="col-lg-4">
                    <div class="media gap-3 mb-30 mb-lg-0">
                        <div class="avatar">
                            <img width="60" class="img-fit rounded-circle" src="<?php echo e($deliveryman->imageFullPath); ?>" alt="<?php echo e(translate('deliveryman')); ?>">
                        </div>

                        <div class="media-body">
                            <h3 class="fz-22 text-title mb-0"><?php echo e($deliveryman->f_name); ?> <?php echo e($deliveryman->l_name); ?></h3>
                            <div class="mb-3">
                                <?php echo e(translate('Joining')); ?>: <span
                                    class="font-weight-medium"><?php echo e($deliveryman->created_at->format('d M Y')); ?></span>
                            </div>
                            <a class="btn btn-primary px-6"
                                href="<?php echo e(route('admin.delivery-man.edit', [$deliveryman['id']])); ?>"><?php echo e(translate('edit')); ?></a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="single-details d-flex gap-20 flex-column flex-sm-row mb-4 mb-lg-0">
                        <div class="border-line d-none d-lg-block"></div>
                        <div class="flex-grow-1">
                            <h5 class="fz-16 text-title opacity-lg mb-3"><?php echo e(translate('Contact info')); ?></h5>
                            <div class="mb-2"><?php echo e($deliveryman->email); ?></div>
                            <div><?php echo e(translate($deliveryman->phone)); ?></div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="single-details-slider owl-carousel owl-theme">
                        <?php $__currentLoopData = $deliveryman->identityImageFullPath; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $identification_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="item">
                                <div class="single-details d-flex gap-20 flex-column flex-sm-row">
                                    <div class="border-line d-none d-lg-block"></div>
                                    <div class="d-flex flex-grow-1 gap-20 justify-content-between flex-column flex-sm-row">
                                        <div>
                                            <h5 class="fz-16 text-title opacity-lg mb-3"><?php echo e(translate('Identity info')); ?>

                                            </h5>
                                            <div class="mb-2">
                                                <?php echo e(translate('Identity Type')); ?>:
                                                <span class="font-weight-medium"><?php echo e($deliveryman->identity_type); ?></span>
                                            </div>
                                            <div>
                                                <?php echo e(translate('Identity Number')); ?>:
                                                <span class="font-weight-medium"><?php echo e($deliveryman->identity_number); ?></span>
                                            </div>
                                        </div>
                                        <div>
                                            <img class="rounded-10 max-w200 max-h100" width="200" height="100"
                                                src="<?php echo e($identification_image); ?>" alt="<?php echo e(translate('identity_image')); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="details-slider-btn">
                        <button class="prev-btn rounded-circle">
                            <i class="tio-back-ui"></i>
                        </button>
                        <button class="next-btn rounded-circle">
                            <i class="tio-next-ui"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-top px-card border-bottom p-20">
                <form action="<?php echo e(url()->current()); ?>" method="GET" id="searchForm">
                    <div class="d-flex gap-4 justify-content-between align-items-end flex-wrap">
                        <input type="hidden" name="search" value="<?php echo e($search); ?>">
                        <div class="form-group flex-grow-1 mb-0">
                            <label class="input-label"><?php echo e(translate('Order_Date')); ?></label>
                            <div class="position-relative">
                                <span class="tio-calendar icon-absolute-on-right"></span>
                                <input type="text" name="date" id="js-daterangepicker-predefined" class="form-control"
                                    placeholder="<?php echo e(translate('Select Date')); ?>" value="<?php echo e(request()->get('date')); ?>" autocomplete="off">
                            </div>
                            
                        </div>
                        <div class="form-group flex-grow-1 mb-0">
                            <label class="input-label"><?php echo e(translate('Branch')); ?></label>
                            <select class="custom-select text-title" name="branch_id" id="branch_id">
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($branch->id); ?>" <?php echo e($branch->id == $branchId ? 'selected' : ''); ?>>
                                        <?php echo e($branch->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary px-6"><?php echo e(translate('filter')); ?></button>
                    </div>
                </form>
            </div>

            <div>
                <div class="d-flex flex-wrap gap-10 mb-30 mt-30 px-20">
                    <div class="flex-grow-1">
                        <div class="resturant-card dashboard--card border-0 shadow-none bg-FF5B7F-light">
                            <div class="mr-4">
                                <h4 class="title"><?php echo e($pendingOrders); ?></h4>
                                <span class="subtitle"><?php echo e(translate('Pending')); ?></span>
                            </div>
                            <div class="resturant-icon round-bg bg-FF5B7F">
                                <img class="" width="16"
                                    src="<?php echo e(asset('public/assets/admin/img/modal/deliveryman-report/pending.svg')); ?>"
                                    alt="">
                            </div>

                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="resturant-card dashboard--card border-0 shadow-none bg-BF83FF-light">
                            <div class="mr-4">
                                <h4 class="title"><?php echo e($outForDeliveryOrders); ?></h4>
                                <span class="subtitle"><?php echo e(translate('Out for Delivery')); ?></span>
                            </div>
                            <div class="resturant-icon round-bg bg-BF83FF">
                                <img class="" width="16"
                                    src="<?php echo e(asset('public/assets/admin/img/modal/deliveryman-report/out-for-delivery.svg')); ?>"
                                    alt="">
                            </div>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="resturant-card dashboard--card border-0 shadow-none bg-3CD856-light">
                            <div class="mr-4">
                                <h4 class="title"><?php echo e($completedOrders); ?></h4>
                                <span class="subtitle"><?php echo e(translate('Completed')); ?></span>
                            </div>
                            <div class="resturant-icon round-bg bg-3CD856">
                                <img class="" width="16"
                                    src="<?php echo e(asset('public/assets/admin/img/modal/deliveryman-report/completed.svg')); ?>"
                                    alt="">
                            </div>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="resturant-card dashboard--card border-0 shadow-none bg-53B65A-light">
                            <div class="mr-4">
                                <h4 class="title"><?php echo e(\App\CentralLogics\Helpers::set_symbol($totalOrderAmount)); ?></h4>
                                <span class="subtitle"><?php echo e(translate('Order Amount')); ?></span>
                            </div>
                            <div class="resturant-icon round-bg bg-53B65A">
                                <img class="" width="16"
                                    src="<?php echo e(asset('public/assets/admin/img/modal/deliveryman-report/earned.svg')); ?>"
                                    alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center px-card mb-3">
                    <div class="col-md-4 col-lg-6">
                        <h5 class="d-flex gap-1">
                            <?php echo e(translate('Order list')); ?>

                            <span class="badge badge-soft-dark rounded-50 fz-12 ml-1"><?php echo e($orders->total()); ?></span>
                        </h5>
                    </div>
                    <div class="col-md-8 col-lg-6">
                        <div class="d-flex gap-3 flex-wrap justify-content-end">
                            <form action="<?php echo e(url()->current()); ?>" method="GET" class="flex-grow-1">
                                <input type="hidden" name="branch_id" value="<?php echo e($branchId); ?>">
                                <input type="hidden" name="date" value="<?php echo e(request()->get('date')); ?>"
                                    id="hiddenDate">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search" class="form-control"
                                        placeholder="Search by order id" aria-label="Search" value="<?php echo e($search); ?>"
                                        autocomplete="off">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary"><?php echo e(translate('Search')); ?></button>
                                    </div>
                                </div>
                            </form>
                            <div>
                                <button type="button" class="btn btn-outline-primary text-nowrap" data-toggle="dropdown"
                                    aria-expanded="false">
                                    <i class="tio-download-to"></i><?php echo e(translate('Export')); ?><i
                                        class="tio-chevron-down"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a type="submit" class="dropdown-item d-flex align-items-center gap-2"
                                            href="<?php echo e(route('admin.delivery-man.order-excel-export', [
                                                'deliveryman_id' => $deliveryman->id,
                                                'branch_id' => request('status'),
                                                'search' => request('search'),
                                                'date' => request('date'),
                                            ])); ?>">
                                            <img width="14"
                                                src="<?php echo e(asset('public/assets/admin/img/icons/excel.png')); ?>"
                                                alt=""><?php echo e(translate('Excel')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive datatable-custom">
                    <table
                        class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo e(translate('SL')); ?></th>
                                <th><?php echo e(translate('Order ID')); ?></th>
                                <th><?php echo e(translate('Customer Info')); ?></th>
                                <th><?php echo e(translate('Order Date')); ?></th>
                                <th class="text-center"><?php echo e(translate('Total Items')); ?></th>
                                <th class="text-center"><?php echo e(translate('Order Amount')); ?></th>
                                <th><?php echo e(translate('Payment Method')); ?></th>
                                <th><?php echo e(translate('Branch')); ?></th>
                                <th class="text-center"><?php echo e(translate('Order Status')); ?></th>
                                <th class="text-center"><?php echo e(translate('Action')); ?></th>
                            </tr>
                        </thead>

                        <tbody id="set-rows">
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="">
                                    <td><?php echo e($orders->firstitem() + $key); ?></td>
                                    <td>
                                        <a class="text-dark"
                                            href="<?php echo e(route('admin.orders.details', ['id' => $order['id']])); ?>"><?php echo e($order['id']); ?></a>
                                    </td>
                                    <td>
                                        <?php if($order->is_guest == 0): ?>
                                            <?php if($order->customer): ?>
                                                <h6 class="text-capitalize mb-1">
                                                    <a class="text-dark"
                                                        href="<?php echo e(route('admin.customer.view', [$order['user_id']])); ?>"><?php echo e($order->customer['f_name'] . ' ' . $order->customer['l_name']); ?></a>
                                                </h6>
                                                <a class="text-dark fz-12"
                                                    href="tel:<?php echo e($order->customer->phone); ?>"><?php echo e($order->customer->phone); ?></a>
                                            <?php else: ?>
                                                <span class="text-capitalize text-muted">
                                                    <?php echo e(translate('Customer_Unavailable')); ?>

                                                </span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <h6 class="text-capitalize text-info">
                                                <?php echo e(translate('Guest Customer')); ?>

                                            </h6>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($order->created_at->format('d M Y,')); ?><br>
                                        <?php echo e($order->created_at->format('h:i A')); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($order->details_count); ?></td>
                                    <td class="text-center">
                                        <?php echo e(\App\CentralLogics\Helpers::set_symbol($order->order_amount + $order->delivery_charge)); ?>

                                    </td>
                                    <td>
                                        <span
                                            class="badge-soft-success px-2 py-1 rounded"><?php echo e(str_replace('_', ' ', $order['payment_method'])); ?></span>
                                    </td>
                                    <td>
                                        <span
                                            class="badge-soft-info px-2 py-1 rounded"><?php echo e($order->branch ? $order->branch->name : 'Branch deleted!'); ?></span>
                                    </td>
                                    <td class="text-capitalize">
                                        <?php if($order['order_status'] == 'pending'): ?>
                                            <span
                                                class="badge-soft-info px-2 py-1 rounded"><?php echo e(translate('pending')); ?></span>
                                        <?php elseif($order['order_status'] == 'confirmed'): ?>
                                            <span
                                                class="badge-soft-info px-2 py-1 rounded"><?php echo e(translate('confirmed')); ?></span>
                                        <?php elseif($order['order_status'] == 'processing'): ?>
                                            <span
                                                class="badge-soft-warning px-2 py-1 rounded"><?php echo e(translate('processing')); ?></span>
                                        <?php elseif($order['order_status'] == 'out_for_delivery'): ?>
                                            <span
                                                class="badge-soft-warning px-2 py-1 rounded"><?php echo e(translate('out_for_delivery')); ?></span>
                                        <?php elseif($order['order_status'] == 'delivered'): ?>
                                            <span
                                                class="badge-soft-success px-2 py-1 rounded"><?php echo e(translate('delivered')); ?></span>
                                        <?php elseif($order['order_status'] == 'failed'): ?>
                                            <span
                                                class="badge-soft-danger px-2 py-1 rounded"><?php echo e(translate('failed_to_deliver')); ?></span>
                                        <?php else: ?>
                                            <span
                                                class="badge-soft-danger px-2 py-1 rounded"><?php echo e(str_replace('_', ' ', $order['order_status'])); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex justify-content-center gap-2">
                                            <a class="btn btn-outline-success btn-sm square-btn"
                                                href="<?php echo e(route('admin.orders.details', ['id' => $order['id']])); ?>">
                                                <i class="tio-visible"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>

                <div class="table-responsive px-3 mt-3">
                    <div class="d-flex justify-content-end">
                        <?php echo $orders->links(); ?>

                    </div>
                </div>
                <?php if(count($orders) == 0): ?>
                    <div class="text-center p-4">
                        <img class="w-120px mb-3" src="<?php echo e(asset('public/assets/admin/svg/illustrations/sorry.svg')); ?>"
                            alt="<?php echo e(translate('image')); ?>">
                        <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $(document).on('ready', function() {
            var start = "<?php echo e(request()->get('date') ? explode(' - ', request()->get('date'))[0] : null); ?>";
            var end = "<?php echo e(request()->get('date') ? explode(' - ', request()->get('date'))[1] : null); ?>";

            start = start ? moment(start, 'D MMM, YYYY') : null;
            end = end ? moment(end, 'D MMM, YYYY') : null;

            function cb(start, end) {
                $('#js-daterangepicker-predefined').val(start.format('D MMM, YYYY') + ' - ' + end.format(
                    'D MMM, YYYY'));
                $('#js-daterangepicker-predefined-preview').html(start.format('D MMM') + ' - ' + end.format(
                    'D MMM, YYYY'));
            }

            $('#js-daterangepicker-predefined').daterangepicker({
                autoUpdateInput: false,
                startDate: start || moment(),
                endDate: end || moment(),
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                },
                locale: {
                    format: 'D MMM, YYYY'
                }
            });

            //cb(start, end);

            // Update the input field and preview when a range is selected
            $('#js-daterangepicker-predefined').on('apply.daterangepicker', function(ev, picker) {
                cb(picker.startDate, picker.endDate);
            });

            // Clear the input and preview on cancel
            $('#js-daterangepicker-predefined').on('cancel.daterangepicker', function() {
                $(this).val('');
                $('.js-daterangepicker-predefined-preview').html('');
            });


            if (start && end) {
                cb(start, end);
            }


            $('#searchForm').on('submit', function() {
                var selectedDate = $('#js-daterangepicker-predefined').val();
                $('#hiddenDate').val(selectedDate);
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var owl = $(".single-details-slider").owlCarousel({
                loop: false,
                margin: 10,
                dots: false,
                nav: false,
                items: 1,
                smartSpeed: 600,
                // rtl: true
            });

            updateNavButtons({
                item: {
                    index: 0,
                    count: owl.find(".owl-item").length
                }
            });

            $(".next-btn").click(function() {
                owl.trigger("next.owl.carousel");
            });

            $(".prev-btn").click(function() {
                owl.trigger("prev.owl.carousel");
            });

            owl.on("changed.owl.carousel", function(event) {
                updateNavButtons(event);
            });

            function updateNavButtons(event) {
                var totalItems = event.item.count;
                var currentIndex = event.item.index;

                if (currentIndex === 0) {
                    $(".prev-btn").hide();
                } else {
                    $(".prev-btn").show();
                }

                if (currentIndex === totalItems - 1) {
                    $(".next-btn").hide();
                } else {
                    $(".next-btn").show();
                }
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/delivery-man/details.blade.php ENDPATH**/ ?>