<?php $__env->startSection('title', translate('Business Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('business_setup')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._business-setup-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <section class="qr-code-section">
            <div class="card">
                <div class="card-body">
                    <div class="qr-area">
                        <div class="left-side pr-xl-4">
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <div class="text-dark w-0 flex-grow-1"><?php echo e(translate('QR Card Design')); ?></div>
                                <div class="btn--container flex-nowrap print-btn-grp">
                                    <a type="button" href="<?php echo e(route('admin.business-settings.restaurant.qrcode.print')); ?>" class="btn btn-primary pt-1"><i class="tio-print"></i> <?php echo e(translate('Print')); ?></a>
                                </div>
                            </div>
                            <?php ($restaurantLogo=\App\Model\BusinessSetting::where(['key'=>'logo'])->first()?->value); ?>
                            <div class="qr-wrapper" style="background: url(<?php echo e(asset('public/assets/admin/img/qr-bg.png')); ?>) no-repeat center center / 100% 100%">
                                <a href="#" class="qr-logo">
                                    <img src="<?php echo e(asset('storage/app/public/qrcode/'.$data['logo'])); ?>" class="mw-100"
                                         onerror="this.src='<?php echo e(asset('public/assets/admin/img/logo2.png')); ?>'" alt="">

                                </a>
                                <p class="view-menu-title">
                                    <?php echo e(isset($data) ? $data['title'] : translate('title')); ?>

                                </p>
                                <div class="text-center mt-4">
                                    <div>
                                        <img src="<?php echo e(asset('public/assets/admin/img/scan-me.png')); ?>" class="mw-100" alt="">
                                    </div>
                                    <div class="my-3">
                                        <?php echo $code; ?>

                                    </div>
                                </div>
                                <div class="subtext">
                                    <span>
                                        <?php echo e(isset($data) ? $data['description'] : translate('description')); ?>

                                    </span>
                                </div>
                                <div class="open-time">
                                    <div><?php echo e(translate('OPEN DAILY')); ?></div>
                                    <div><?php echo e(isset($data) ? $data['opening_time'] : '09:00 AM'); ?> - <?php echo e(isset($data) ? $data['closing_time'] : '09:00 PM'); ?></div>
                                </div>
                                <div class="phone-number">
                                    <?php echo e(translate('PHONE NUMBER')); ?> : <?php echo e(isset($data) ? $data['phone'] : '+00 123 4567890'); ?>

                                </div>
                                <div class="row g-0 text-center bottom-txt">
                                    <div class="col-6 border-right py-3 px-2">
                                        <?php echo e(isset($data) ? $data['website'] : 'www.website.com'); ?>

                                    </div>
                                    <div class="col-6 py-3">
                                        <?php echo e(isset($data) ? $data['social_media'] : translate('@social-media-name')); ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="right-side">
                            <form method="post" action="<?php echo e(route('admin.business-settings.restaurant.qrcode.store')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-12" id="branch_section">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Branch')); ?></label>
                                            <select class="form-control js-select2-custom" name="branch_id">
                                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($branch['id']); ?>"><?php echo e($branch['name']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Logo / Icon')); ?></label>
                                            <label class="custom-file">
                                                <input type="file" name="logo" class="custom-file-input"
                                                       accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                                <span class="custom-file-label"><?php echo e(translate('choose_File')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Title')); ?></label>
                                            <input type="text" name="title" placeholder="<?php echo e(translate('Ex : Title')); ?>" class="form-control" value="<?php echo e(old('title')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Description')); ?></label>
                                            <input type="text" name="description" placeholder="<?php echo e(translate('Ex : Description')); ?>" value="<?php echo e(old('description')); ?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Opening Time')); ?></label>
                                            <input type="time" class="form-control" name="opening_time" value="<?php echo e(old('opening_time')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Closing Time')); ?></label>
                                            <input type="time" class="form-control" name="closing_time" value="<?php echo e(old('closing_time')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Phone')); ?></label>
                                            <input type="text" name="phone" placeholder="<?php echo e(translate('Ex : +123456')); ?>" value="<?php echo e(old('phone')); ?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Website Link')); ?></label>
                                            <input type="text" name="website" value="<?php echo e(old('website')); ?>" placeholder="<?php echo e(translate('Ex : www.website.com')); ?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="input-label"><?php echo e(translate('Social Media Name')); ?></label>
                                            <input type="text" placeholder="<?php echo e(translate('@social media name')); ?>" name="social_media" value="<?php echo e(old('social_media')); ?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="btn--container">
                                            <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                            <button type="submit" class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/qrcode-index.blade.php ENDPATH**/ ?>